/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.io.OutputStream;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.providers.AbstractConnectionStrategy;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.security.SecurityException;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractMessageDispatcher
implements UMOMessageDispatcher,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOWorkManager workManager = null;
    protected UMOImmutableEndpoint endpoint;
    protected AbstractConnector connector;
    protected boolean disposed = false;
    protected boolean doThreading = true;
    protected ConnectionStrategy connectionStrategy;
    protected WaitableBoolean connected = new WaitableBoolean(false);
    private AtomicBoolean connecting = new AtomicBoolean(false);

    public AbstractMessageDispatcher(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
        this.connectionStrategy = this.connector.getConnectionStrategy();
        if (this.connectionStrategy instanceof AbstractConnectionStrategy) {
            ((AbstractConnectionStrategy)this.connectionStrategy).setDoThreading(false);
        }
        ThreadingProfile profile = this.connector.getDispatcherThreadingProfile();
        this.doThreading = profile.isDoThreading();
        if (this.doThreading) {
            this.workManager = this.connector.createDispatcherWorkManager(this.connector.getName() + ".dispatchers");
            try {
                this.workManager.start();
            }
            catch (UMOException e) {
                this.dispose();
                throw new MuleRuntimeException(new Message(42, "WorkManager"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void dispatch(UMOEvent event) throws DispatchException {
        event.setSynchronous(false);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        RequestContext.setEvent(event);
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 600));
                this.connector.handleException(e);
                if (!this.connector.isCreateDispatcherPerRequest()) return;
                this.dispose();
                return;
            }
            catch (UMOException e) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        event = RequestContext.getEvent();
        try {
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.doThreading && !event.isSynchronous() && tx == null) {
                this.workManager.scheduleWork(new Worker(event), 0L, null, this.connector);
                return;
            }
            this.connectionStrategy.connect(this);
            this.doDispatch(event);
            if (!this.connector.isEnableMessageEvents()) return;
            String component = null;
            if (event.getComponent() != null) {
                component = event.getComponent().getDescriptor().getName();
            }
            this.connector.fireNotification(new MessageNotification(event.getMessage(), event.getEndpoint(), component, 802));
            return;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        finally {
            if (this.connector.isCreateDispatcherPerRequest()) {
                this.dispose();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final UMOMessage send(UMOEvent event) throws DispatchException {
        event.setSynchronous(true);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        RequestContext.setEvent(event);
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.connector.handleException(e);
                UMOMessage uMOMessage = event.getMessage();
                if (!this.connector.isCreateDispatcherPerRequest()) return uMOMessage;
                this.dispose();
                return uMOMessage;
            }
            catch (UMOException e) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        event = RequestContext.getEvent();
        try {
            this.connectionStrategy.connect(this);
            UMOMessage result = this.doSend(event);
            if (this.connector.isEnableMessageEvents()) {
                String component = null;
                if (event.getComponent() != null) {
                    component = event.getComponent().getDescriptor().getName();
                }
                this.connector.fireNotification(new MessageNotification(event.getMessage(), event.getEndpoint(), component, 803));
            }
            if (result == null) return result;
            result.removeProperty("MULE_REMOTE_SYNC");
            return result;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
            catch (Exception e2) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e2);
            }
        }
        finally {
            if (this.connector.isCreateDispatcherPerRequest()) {
                this.dispose();
            }
        }
    }

    public final UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        return this.receive(new ImmutableMuleEndpoint(endpointUri.toString(), true), timeout);
    }

    public final UMOMessage receive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        try {
            this.connectionStrategy.connect(this);
            UMOMessage result = this.doReceive(endpoint, timeout);
            if (result != null && this.connector.isEnableMessageEvents()) {
                String component = null;
                this.connector.fireNotification(new MessageNotification(result, endpoint, component, 801));
            }
            UMOMessage uMOMessage = result;
            return uMOMessage;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new ReceiveException(endpoint, timeout, e);
        }
        finally {
            if (this.connector.isCreateDispatcherPerRequest()) {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionThrown(Exception e) {
        try {
            this.getConnector().handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.disposed) {
            try {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                this.doDispose();
                if (this.workManager != null) {
                    this.workManager.dispose();
                }
            }
            finally {
                this.disposed = true;
            }
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    protected boolean useRemoteSync(UMOEvent event) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isRemoteSyncEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isRemoteSync() || event.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", false);
            if (remoteSync && event.getComponent() != null) {
                boolean bl2 = remoteSync = event.getComponent().getDescriptor().getResponseRouter() == null;
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    public OutputStream getOutputStream(UMOImmutableEndpoint endpoint, UMOMessage message) throws UMOException {
        return null;
    }

    public void connect() throws Exception {
        if (this.connected.get()) {
            return;
        }
        if (this.disposed && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Dispatcher has been disposed. Cannot connector resource");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to connect to: " + this.endpoint.getEndpointURI()));
        }
        if (this.connecting.compareAndSet(false, true)) {
            this.connectionStrategy.connect(this);
            this.logger.info((Object)("Successfully connected to: " + this.endpoint.getEndpointURI()));
            return;
        }
        try {
            this.doConnect(this.endpoint);
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 701));
        }
        catch (Exception e) {
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 702));
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException(e, (Object)this);
        }
        this.connected.set(true);
        this.connecting.set(false);
    }

    public void disconnect() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting from: " + this.endpoint.getEndpointURI()));
        }
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
        this.connected.set(false);
        this.doDisconnect();
        this.logger.info((Object)("Disconnected from: " + this.endpoint.getEndpointURI()));
    }

    protected String getConnectEventId(UMOImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher (" + endpoint.getEndpointURI() + ")";
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    public void reconnect() throws Exception {
        this.disconnect();
        this.connect();
    }

    protected abstract void doDispose();

    protected abstract void doDispatch(UMOEvent var1) throws Exception;

    protected abstract UMOMessage doSend(UMOEvent var1) throws Exception;

    protected abstract void doConnect(UMOImmutableEndpoint var1) throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected abstract UMOMessage doReceive(UMOImmutableEndpoint var1, long var2) throws Exception;

    private class Worker
    implements Work {
        private UMOEvent event;

        public Worker(UMOEvent event) {
            this.event = event;
        }

        public void run() {
            try {
                RequestContext.setEvent(this.event);
                AbstractMessageDispatcher.this.connectionStrategy.connect(AbstractMessageDispatcher.this);
                AbstractMessageDispatcher.this.doDispatch(this.event);
                if (AbstractMessageDispatcher.this.connector.isEnableMessageEvents()) {
                    String component = null;
                    if (this.event.getComponent() != null) {
                        component = this.event.getComponent().getDescriptor().getName();
                    }
                    AbstractMessageDispatcher.this.connector.fireNotification(new MessageNotification(this.event.getMessage(), this.event.getEndpoint(), component, 802));
                }
            }
            catch (Exception e) {
                AbstractMessageDispatcher.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

