/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.apache.commons.lang.ObjectUtils;
import org.mule.impl.AbstractExceptionListener;
import org.mule.impl.RequestContext;
import org.mule.impl.message.ExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class DefaultExceptionStrategy
extends AbstractExceptionListener {
    public void handleMessagingException(UMOMessage message, Throwable t) {
        this.defaultHandler(t);
        this.routeException(message, null, t);
    }

    public void handleRoutingException(UMOMessage message, UMOImmutableEndpoint endpoint, Throwable t) {
        this.defaultHandler(t);
        this.routeException(message, endpoint, t);
    }

    public void handleLifecycleException(Object component, Throwable t) {
        this.defaultHandler(t);
        this.logger.error((Object)("The object that failed was: \n" + ObjectUtils.toString((Object)component, (String)"null")));
        this.markTransactionForRollback();
    }

    public void handleStandardException(Throwable t) {
        this.defaultHandler(t);
        this.markTransactionForRollback();
    }

    protected void defaultHandler(Throwable t) {
        this.logException(t);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(new ExceptionPayload(t));
        }
    }
}

