/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rule;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;

public class EnforcerPortRule
implements EnforcerRule {
    private boolean shouldIfail = false;
    private int port = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        log.info((CharSequence)("checking availability of port : " + this.port));
        if (this.port <= 0) {
            throw new EnforcerRuleException("Port is not valid " + this.port);
        }
        if (!EnforcerPortRule.available(this.port)) {
            throw new EnforcerRuleException("Port is not available " + this.port);
        }
        if (this.shouldIfail) {
            throw new EnforcerRuleException("Failing because my param said so.");
        }
    }

    public String getCacheId() {
        return "" + this.shouldIfail;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

