/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.microsoft.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class SamlTokenUtils {
    private SamlTokenUtils() {
    }

    public static String getRequestedSecurityTokenFromSecurityTokenResponse(String securityTokenResponse) throws MicrosoftAuthenticationException {
        try {
            return SamlTokenUtils.getValueFromXml(securityTokenResponse, "RequestedSecurityToken");
        }
        catch (Exception e) {
            throw new MicrosoftAuthenticationException("Error when reading the element 'RequestedSecurityToken' from the Security Token Response :'" + securityTokenResponse + "'.");
        }
    }

    public static Document createDocument(String inputXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(inputXML.getBytes(Charset.forName("UTF-8"))));
    }

    public static Node findNode(Object document, String xPathQuery) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (Node)xpath.evaluate(xPathQuery, document, XPathConstants.NODE);
    }

    public static String getValueFromXml(String inputXML, String elementName) throws MicrosoftAuthenticationException {
        Pattern pattern = Pattern.compile("<.*" + elementName + ".*?>(.*)</.*" + elementName + ">", 32);
        Matcher matcher = pattern.matcher(inputXML);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }
}

