/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.microsoft.adfs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationBase;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationException;
import org.mule.modules.security.microsoft.utils.SamlTokenUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class AdfsAuthentication
extends MicrosoftAuthenticationBase {
    public static final String ADFS_USERNAME_PORTNAME = "{http://schemas.microsoft.com/ws/2008/06/identity/securitytokenservice}UserNameWSTrustBinding_IWSTrust13Async";

    public AdfsAuthentication() throws MicrosoftAuthenticationException {
        this(false);
    }

    public AdfsAuthentication(boolean disableSslCheck) throws MicrosoftAuthenticationException {
        this(AdfsAuthentication.createHttpClient(disableSslCheck));
    }

    public AdfsAuthentication(CloseableHttpClient httpClient) {
        super(httpClient);
    }

    public String getTokenFromAdfs(String username, String password, String appliesTo, String metadataExchangeUrl, String usernamePortName) throws MicrosoftAuthenticationException {
        String usernameEndpoint = AdfsAuthentication.getUsernameEndpointFromMetadataExchange(this.getHttpClient(), metadataExchangeUrl, QName.valueOf(usernamePortName).getLocalPart());
        return this.getTokenFromAdfs(username, password, appliesTo, usernameEndpoint);
    }

    public String getTokenFromAdfs(String username, String password, String appliesTo, String usernameEndpoint) throws MicrosoftAuthenticationException {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(gmt);
        Calendar calendarFiveMinute = (Calendar)calendar.clone();
        calendarFiveMinute.add(12, 5);
        Date nowDate = calendar.getTime();
        Date fiveMinuteFromNow = calendarFiveMinute.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(gmt);
        String soapMessageTemplate = this.loadSoapMessage("AdfsUsernamePassword13.xml");
        String messageId = UUID.randomUUID().toString();
        String toId = UUID.randomUUID().toString();
        String timestampId = UUID.randomUUID().toString();
        String created = formatter.format(nowDate);
        String expires = formatter.format(fiveMinuteFromNow);
        String usernameTokenId = UUID.randomUUID().toString();
        String body = String.format(soapMessageTemplate, messageId, toId, usernameEndpoint, timestampId, created, expires, usernameTokenId, username, password, appliesTo);
        String response = AdfsAuthentication.getSecurityTokenRequestResponseFromSts("ADFS", this.getHttpClient(), usernameEndpoint, body);
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getUsernameEndpointFromMetadataExchange(CloseableHttpClient httpClient, String metadataExchangeUrl, String usernamePortName) throws MicrosoftAuthenticationException {
        HttpGet httpGet = new HttpGet(metadataExchangeUrl);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            Document document = SamlTokenUtils.createDocument(response);
            Node username13EndpointAddressNode = SamlTokenUtils.findNode(document, "/*[local-name()='definitions']/*[local-name()='service']/*[local-name()='port' and @name='" + usernamePortName + "']/*[local-name()='EndpointReference']/*[local-name()='Address']");
            String string = username13EndpointAddressNode.getTextContent();
            return string;
        }
        catch (Exception e) {
            throw MicrosoftAuthenticationException.adfsUnableToGetUsernamePortFromMetadataExchange(metadataExchangeUrl, usernamePortName, e);
        }
    }
}

