/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.microsoft;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.mule.modules.security.microsoft.InvalidAppliesToException;
import org.mule.modules.security.microsoft.InvalidCredentialsException;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationException;
import org.mule.modules.security.microsoft.utils.SamlTokenUtils;

public abstract class MicrosoftAuthenticationBase {
    private final CloseableHttpClient httpClient;

    protected MicrosoftAuthenticationBase(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected String loadSoapMessage(String xmlFileName) throws MicrosoftAuthenticationException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource("SoapAuthMessages/" + xmlFileName);
        try {
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new MicrosoftAuthenticationException("Unable to read soap message from resources: " + xmlFileName);
        }
    }

    protected static CloseableHttpClient createHttpClient(boolean disableCnCheck) throws MicrosoftAuthenticationException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties();
        if (disableCnCheck) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
            }
            catch (Exception e) {
                throw new MicrosoftAuthenticationException("Error when disabling the SSL certificate check. Check the stack trace for more details.", e);
            }
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getSecurityTokenRequestResponseFromSts(String context, CloseableHttpClient httpClient, String usernameEndpoint, String body) throws MicrosoftAuthenticationException {
        HttpPost postRequest = new HttpPost(usernameEndpoint);
        postRequest.setHeader("content-type", "application/soap+xml;charset=UTF-8");
        try {
            postRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        catch (UnsupportedEncodingException e) {
            throw MicrosoftAuthenticationException.genericRequestSecurityTokenError(context, e);
        }
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)postRequest);){
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode == 500 || SamlTokenUtils.getRequestedSecurityTokenFromSecurityTokenResponse(response) == null) {
                MicrosoftAuthenticationException microsoftAuthenticationException = MicrosoftAuthenticationException.requestSecurityTokenErrorForResponse(context, statusCode, response);
                if (StringUtils.containsIgnoreCase((String)response, (String)"FailedAuthentication")) {
                    throw InvalidCredentialsException.invalidCredentials(context, microsoftAuthenticationException);
                }
                if (!StringUtils.containsIgnoreCase((String)response, (String)"InvalidScope")) throw microsoftAuthenticationException;
                throw InvalidAppliesToException.invalidAppliesTo(context, microsoftAuthenticationException);
            }
            String string = response;
            return string;
        }
        catch (MicrosoftAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw MicrosoftAuthenticationException.genericRequestSecurityTokenError(context, e);
        }
    }

    protected CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }
}

