/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import org.apache.commons.lang3.StringUtils;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class NotBlankStringValidator
extends AbstractValidator {
    private final String value;
    private I18nMessage errorMessage;

    public NotBlankStringValidator(String value, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
    }

    @Override
    public ValidationResult validate() {
        if (this.value == null) {
            this.errorMessage = this.getMessages().valueIsNull();
            return this.fail();
        }
        if (StringUtils.isBlank((CharSequence)this.value)) {
            this.errorMessage = this.getMessages().stringIsBlank();
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.BLANK_STRING;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

