/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.ip;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.mule.runtime.core.api.util.StringUtils;

public class IpMatcher {
    private int mask;
    private InetAddress address;

    public IpMatcher(String ipAddress) {
        if (ipAddress.indexOf(47) > 0) {
            String[] addressAndMask = StringUtils.splitAndTrim((String)ipAddress, (String)"/");
            ipAddress = addressAndMask[0];
            this.mask = Integer.parseInt(addressAndMask[1]);
        } else {
            this.mask = -1;
        }
        this.address = this.parseAddress(ipAddress);
    }

    public boolean matchIp(String ipAddress) {
        InetAddress remoteAddress = this.parseAddress(ipAddress);
        if (!this.address.getClass().equals(remoteAddress.getClass())) {
            return false;
        }
        if (this.mask < 0) {
            return remoteAddress.equals(this.address);
        }
        int oddBits = this.mask % 8;
        int nMaskBytes = this.mask / 8 + (oddBits == 0 ? 0 : 1);
        byte[] mask = new byte[nMaskBytes];
        Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
        if (oddBits != 0) {
            int finalByte = (1 << oddBits) - 1;
            mask[mask.length - 1] = (byte)(finalByte <<= 8 - oddBits);
        }
        byte[] remoteAddressBytes = remoteAddress.getAddress();
        byte[] requiredAddressBytes = this.address.getAddress();
        for (int i = 0; i < mask.length; ++i) {
            if ((remoteAddressBytes[i] & mask[i]) == (requiredAddressBytes[i] & mask[i])) continue;
            return false;
        }
        return true;
    }

    private InetAddress parseAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to parse address" + address, e);
        }
    }
}

