/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.extension.validation.internal.validator.ElapsedValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class NotElapsedValidator
extends AbstractValidator {
    private final Duration interval;
    private final LocalDateTime since;
    private I18nMessage errorMessage;

    public NotElapsedValidator(Long time, TimeUnit timeUnit, LocalDateTime since, ValidationContext validationContext) {
        super(validationContext);
        this.since = since;
        this.interval = Duration.of(time, ElapsedValidator.chronoUnit(timeUnit));
    }

    @Override
    public ValidationResult validate() {
        LocalDateTime currentTime = LocalDateTime.now();
        if (!currentTime.isBefore(this.since.plus(this.interval))) {
            this.errorMessage = this.getMessages().elapsedTime(this.since, this.interval, currentTime);
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.ELAPSED_TIME;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

