/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.privileged;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.HasMessageProcessors;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;

abstract class AggregateOperationExecutor
implements CompletableComponentExecutor<OperationModel> {
    AggregateOperationExecutor() {
    }

    public void execute(ExecutionContext<OperationModel> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
        HasMessageProcessors chain = (HasMessageProcessors)executionContext.getParameter("validations");
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        CoreEvent event = context.getEvent();
        Optional<ComponentLocation> location = Optional.ofNullable(context.getComponent().getLocation());
        ArrayList<Error> errors = new ArrayList<Error>(chain.getMessageProcessors().size());
        for (Processor processor : chain.getMessageProcessors()) {
            BaseEventContext childContext = MessageProcessors.newChildContext((CoreEvent)event, location);
            CoreEvent processEvent = CoreEvent.builder((EventContext)childContext, (CoreEvent)event).build();
            try {
                CoreEvent result = processor.process(processEvent);
                childContext.success(result);
            }
            catch (EventProcessingException e) {
                childContext.error((Throwable)e);
                Error error = e.getEvent().getError().orElse(null);
                if (error != null && this.isValidation(error.getErrorType())) {
                    errors.add(error);
                    continue;
                }
                callback.error((Throwable)new EventProcessingException(CoreEvent.builder((EventContext)event.getContext(), (CoreEvent)event).error(error).build(), e.getCause()));
            }
            catch (Exception e) {
                childContext.error((Throwable)e);
                callback.error((Throwable)e);
            }
        }
        this.handleValidationErrors(callback, chain, errors);
    }

    protected abstract void handleValidationErrors(CompletableComponentExecutor.ExecutorCallback var1, HasMessageProcessors var2, List<Error> var3);

    private boolean isValidation(ErrorType errorType) {
        if (errorType == null) {
            return false;
        }
        if (MuleErrors.VALIDATION.getType().equals(errorType.getIdentifier()) && "MULE".equals(errorType.getNamespace())) {
            return true;
        }
        return this.isValidation(errorType.getParentErrorType());
    }
}

