/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.extension.validation.api.IpFilterList;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ip.address.IPAddress;
import org.mule.extension.validation.internal.ip.address.IPAddressFactory;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpFilterValidator
extends AbstractValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpFilterValidator.class);
    private static final Pattern REMOTE_ADDRESS_PATTERN = Pattern.compile("([^/]*)/(.*):(.*)");
    public static final boolean CHECK_RANGE_EXCLUSION = false;
    public static final boolean CHECK_RANGE_INCLUSION = true;
    private IPAddressFactory factory = new IPAddressFactory();
    private final String ip;
    private final IpFilterList ipList;
    private final boolean expectedRangeCondition;
    private ValidationErrorType errorType;
    private I18nMessage errorMessage;

    public IpFilterValidator(String ip, IpFilterList ipList, boolean expectedRangeCondition, ValidationContext validationContext) {
        super(validationContext);
        this.ip = ip;
        this.ipList = ipList;
        this.expectedRangeCondition = expectedRangeCondition;
    }

    @Override
    public ValidationResult validate() {
        String actualIp = this.format(this.ip);
        IPAddress ipAddress = this.factory.create(actualIp);
        LOGGER.trace("Verifying IP: {}", (Object)actualIp);
        if (!ipAddress.isValid()) {
            this.errorType = ValidationErrorType.INVALID_IP;
            this.errorMessage = this.getMessages().invalidIp(this.ip);
            return this.fail();
        }
        if (!this.isInRange(ipAddress, this.ipList.ipAddresses()) == this.expectedRangeCondition) {
            this.errorType = ValidationErrorType.REJECTED_IP;
            this.errorMessage = this.getMessages().rejectedIp(this.ip);
            return this.fail();
        }
        LOGGER.trace("IP {} is valid.", (Object)actualIp);
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }

    private boolean isInRange(IPAddress ipAddress, List<IPAddress> ranges) {
        return ranges.stream().anyMatch(range -> ipAddress.matches((IPAddress)range));
    }

    private String format(String ipAddress) {
        String formattedIp = ipAddress;
        Matcher ipMatcher = REMOTE_ADDRESS_PATTERN.matcher(ipAddress);
        if (ipMatcher.find()) {
            formattedIp = ipMatcher.group(2);
        }
        return formattedIp;
    }
}

