/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.api;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.spring.internal.context.SpringModuleApplicationContext;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProviderConfiguration;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringConfig
extends AbstractComponent
implements ConfigurableObjectProvider,
Disposable,
NamedObject {
    private static final String SPRING_NAMESPACE_PREFIX = "org.springframework";
    private Map<String, String> parameters;
    private ClassPathXmlApplicationContext applicationContext;
    private String name;

    public void setParameters(Map<String, String> parameters) {
        this.name = parameters.get("name");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (String)"spring config name cannot be null");
        this.parameters = parameters;
    }

    public void configure(ObjectProviderConfiguration configuration) {
        ClassUtils.withContextClassLoader((ClassLoader)SpringConfig.class.getClassLoader(), () -> {
            String files = this.parameters.get("files");
            String[] configFiles = files.split(",");
            this.applicationContext = new SpringModuleApplicationContext(configFiles, configuration);
            this.applicationContext.setClassLoader(SpringConfig.class.getClassLoader());
            this.applicationContext.refresh();
        });
    }

    public Optional<Object> getObject(String name) {
        try {
            if (!this.applicationContext.containsBean(name)) {
                return Optional.empty();
            }
            return Optional.of(this.applicationContext.getBean(name));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    public Optional<Object> getObjectByType(Class<?> objectType) {
        try {
            if (this.isSpringInternalType(objectType)) {
                return Optional.empty();
            }
            return Optional.of(this.applicationContext.getBean(objectType));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    private boolean isSpringInternalType(Class<?> objectType) {
        return objectType.getClass().getName().startsWith(SPRING_NAMESPACE_PREFIX) || BeanPostProcessor.class.isAssignableFrom(objectType) || BeanFactoryPostProcessor.class.isAssignableFrom(objectType);
    }

    public Optional<Boolean> isObjectSingleton(String name) {
        try {
            return Optional.of(this.applicationContext.isSingleton(name));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    public boolean containsObject(String name) {
        return this.applicationContext.containsBean(name);
    }

    public <T> Map<String, T> getObjectsByType(Class<T> type) {
        if (this.isSpringInternalType(type)) {
            return Collections.emptyMap();
        }
        Map beans = this.applicationContext.getBeansOfType(type);
        return beans.entrySet().stream().filter(entry -> this.applicationContext.getBeanFactory().containsBeanDefinition((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void dispose() {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
            this.applicationContext = null;
        }
    }

    public String getName() {
        return this.name;
    }
}

