/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.context;

import org.mule.extension.spring.api.ArtifactPropertiesPlaceholder;
import org.mule.extension.spring.internal.beanfactory.ArtifactObjectsAwareBeanFactory;
import org.mule.extension.spring.internal.inject.MuleAwareObjectsInjectorProcessor;
import org.mule.runtime.api.ioc.ObjectProviderConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringModuleApplicationContext
extends ClassPathXmlApplicationContext {
    private static final String AUTOWIRED_POST_PROCESSOR_OBJECT_KEY = "_autowiredPostProcessor";
    private static final String ARTIFACT_PROPERTY_PLACEHOLDER_OBJECT_KEY = "_artifactPropertyPlaceholder";
    private ObjectProviderConfiguration configuration;
    private ArtifactObjectsAwareBeanFactory beanFactory;

    public SpringModuleApplicationContext(String[] configLocations, ObjectProviderConfiguration configuration) throws BeansException {
        super(configLocations, false);
        this.configuration = configuration;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        this.beanFactory = new ArtifactObjectsAwareBeanFactory(this.getInternalParentBeanFactory(), this.configuration.getArtifactObjectProvider());
        return this.beanFactory;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        defaultListableBeanFactory.registerBeanDefinition("org.springframework.context.annotation.internalAutowiredAnnotationProcessor", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(MuleAwareObjectsInjectorProcessor.class).getBeanDefinition());
        defaultListableBeanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        defaultListableBeanFactory.registerBeanDefinition(AUTOWIRED_POST_PROCESSOR_OBJECT_KEY, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class).getBeanDefinition());
        this.registerArtifactPropertiesPlaceholder(defaultListableBeanFactory, this.configuration);
    }

    private void registerArtifactPropertiesPlaceholder(DefaultListableBeanFactory defaultListableBeanFactory, ObjectProviderConfiguration configuration) {
        BeanDefinitionBuilder artifactPlaceholderBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(ArtifactPropertiesPlaceholder.class).addConstructorArgValue((Object)configuration.getConfigurationProperties());
        defaultListableBeanFactory.registerBeanDefinition(ARTIFACT_PROPERTY_PLACEHOLDER_OBJECT_KEY, (BeanDefinition)artifactPlaceholderBeanDefinitionBuilder.getBeanDefinition());
    }

    public void destroy() {
        this.beanFactory.markForDestroy();
        super.destroy();
    }
}

