/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.security;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.mule.extension.spring.internal.config.i18n.SpringSecurityMessages;
import org.mule.extension.spring.internal.security.SpringAuthenticationAdapter;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.NotPermittedException;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnauthorisedException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.security.AbstractSecurityFilter;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationFilter
extends AbstractSecurityFilter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Collection<String> requiredAuthorities = new HashSet<String>();

    public AuthorizationFilter(Collection<String> requiredAuthorities) {
        this.requiredAuthorities = requiredAuthorities;
    }

    public SecurityContext doFilter(CoreEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        Authentication auth = event.getSecurityContext().getAuthentication();
        if (auth == null) {
            throw new UnauthorisedException(CoreMessages.authNoCredentials());
        }
        if (!(auth instanceof SpringAuthenticationAdapter)) {
            throw new UnauthorisedException(SpringSecurityMessages.springAuthenticationRequired());
        }
        SpringAuthenticationAdapter springAuth = (SpringAuthenticationAdapter)auth;
        String principalName = springAuth.getName();
        Object[] authorities = springAuth.getAuthorities();
        boolean authorized = false;
        if (authorities != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found authorities '" + Arrays.toString(authorities) + "' for principal '" + principalName + "'.");
            }
            for (Object authority : authorities) {
                if (!this.requiredAuthorities.contains(authority.getAuthority())) continue;
                authorized = true;
            }
        }
        if (!authorized) {
            this.logger.info(MessageFormat.format("Could not find required authorities for {0}. Required authorities: {1}. Authorities found: {2}.", principalName, Arrays.toString(this.requiredAuthorities.toArray()), Arrays.toString(authorities)));
            throw new NotPermittedException(SpringSecurityMessages.noGrantedAuthority(principalName));
        }
        return event.getSecurityContext();
    }
}

