/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.soapkit.internal.exception.SoapkitRouterException;
import org.mule.module.soapkit.internal.util.HttpListenerUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.soapkit.soap.util.Cast;

public class SoapkitRouterAttributes {
    private static final String HEADERS = "headers";
    private static final String METHOD = "method";
    private static final String QUERY_STRING = "queryString";
    private static final String ATTRIBUTES_PARAM = "attributes";
    private static final String BIND_TO_ALL_INTERFACES = "0.0.0.0";
    private static final String FULL_DOMAIN = "fullDomain";
    private Map<String, Object> attributes;
    private URI location;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";

    private SoapkitRouterAttributes(Map<String, Object> attributes, URI location) {
        this.attributes = attributes;
        this.location = location;
        this.validate();
    }

    static SoapkitRouterAttributes create(ExecutionContextAdapter<OperationModel> context, ConfigurationComponentLocator componentLocator, String address) {
        Map attributes = (Map)context.getParameter(ATTRIBUTES_PARAM);
        ComponentLocation componentLocation = context.getComponent().getLocation();
        String name = componentLocation.getRootContainerName();
        URI location = componentLocator.find(Location.builder().globalName(name).addSourcePart().build()).map(HttpListenerUtils::getUriFromFlow).orElseThrow(() -> new RuntimeException("Missing location form Http component name '" + name + "'"));
        return new SoapkitRouterAttributes(attributes, SoapkitRouterAttributes.fixLocation(location, address));
    }

    private void validate() {
        Object object = this.attributes.get(HEADERS);
        if (object == null) {
            throw new SoapkitRouterException(I18nMessageFactory.createStaticMessage((String)"Header attribute is missing"));
        }
        if (!(object instanceof Map)) {
            throw new SoapkitRouterException(I18nMessageFactory.createStaticMessage((String)"Header attribute is not a key -> value map"));
        }
    }

    private Map<String, String> getHeaders() {
        return (Map)Cast.cast((Object)this.attributes.get(HEADERS));
    }

    public Map<String, String> getTransportHeaders() {
        HashMap<String, String> transportHeaders = new HashMap<String, String>();
        this.getHeaders().forEach((key, value) -> transportHeaders.put("mule.soap.http.headers." + key, (String)value));
        this.getMethod().ifPresent(value -> transportHeaders.put("mule.soap.http.attributes.method", (String)value));
        this.getQueryString().ifPresent(value -> transportHeaders.put("mule.soap.http.attributes.query.string", (String)value));
        transportHeaders.put("mule.soap.http.attributes.location", this.location.toString());
        return transportHeaders;
    }

    private Optional<String> getMethod() {
        return this.optionalAttribute(METHOD);
    }

    private Optional<String> getQueryString() {
        return this.optionalAttribute(QUERY_STRING);
    }

    private Optional<String> optionalAttribute(String key) {
        Object value = this.attributes.get(key);
        return value instanceof String && StringUtils.isNotEmpty((CharSequence)((String)value)) ? Optional.of((String)value) : Optional.empty();
    }

    private static URI fixLocation(URI location, String address) {
        Object fullDomain;
        Object baseUriReplacement = location.toString();
        if (!((String)baseUriReplacement).contains(BIND_TO_ALL_INTERFACES)) {
            return location;
        }
        Object object = fullDomain = StringUtils.isNotEmpty((CharSequence)address) ? address : System.getProperty(FULL_DOMAIN);
        if (fullDomain != null) {
            String path = location.getPath();
            if (((String)fullDomain).endsWith("/") && path.length() > 0 && path.startsWith("/")) {
                path = path.length() > 1 ? path.substring(1) : "";
            } else if (!((String)fullDomain).endsWith("/") && path.length() > 0 && !path.startsWith("/")) {
                fullDomain = (String)fullDomain + "/";
            }
            if (((String)fullDomain).contains("://")) {
                baseUriReplacement = (String)fullDomain + path;
            } else {
                String protocol = location.toString().contains(HTTPS) ? HTTPS : HTTP;
                baseUriReplacement = protocol + (String)fullDomain + path;
            }
        } else {
            baseUriReplacement = ((String)baseUriReplacement).replace(BIND_TO_ALL_INTERFACES, "localhost");
        }
        try {
            return new URI((String)baseUriReplacement);
        }
        catch (Exception e) {
            return location;
        }
    }
}

