/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal;

import java.net.URL;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.module.soapkit.internal.util.WsdlUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.ValuePart;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class WsdlConnectionInfo {
    @Placement(order=1)
    @Parameter
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"wsdl"}, acceptsUrls=true)
    private String wsdlLocation;
    @Placement(order=2)
    @Parameter
    @ValuePart(order=1)
    private String service;
    @Placement(order=3)
    @Parameter
    @ValuePart(order=2)
    private String port;
    private WsdlParser wsdlParser = null;
    private XmlTypeLoader typeLoader = null;
    private URL wsdlLocationUrl = null;

    public WsdlConnectionInfo() {
    }

    public WsdlConnectionInfo(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getService() {
        return this.service;
    }

    public String getPort() {
        return this.port;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public WsdlModel getWsdlModel() throws ConnectionException {
        return this.getWsdlParser().getWsdl();
    }

    public XmlTypeLoader getXmlTypeLoader() throws ConnectionException {
        if (this.typeLoader != null) {
            return this.typeLoader;
        }
        SchemaCollector schemas = SchemaCollector.getInstance();
        this.getWsdlParser().collectSchemas().forEach((arg_0, arg_1) -> ((SchemaCollector)schemas).addSchema(arg_0, arg_1));
        this.typeLoader = new XmlTypeLoader(schemas);
        return this.typeLoader;
    }

    public URL getWsdlLocationUrl() throws ConnectionException {
        if (this.wsdlLocationUrl != null) {
            return this.wsdlLocationUrl;
        }
        if (StringUtils.isBlank((String)this.wsdlLocation)) {
            throw new ConnectionException("Parameter wsdlLocation is missing in config");
        }
        this.wsdlLocationUrl = WsdlUtils.getWsdlLocationUrl(this.wsdlLocation);
        return this.wsdlLocationUrl;
    }

    public ServiceModel getServiceModel() throws ConnectionException {
        if (StringUtils.isBlank((String)this.service)) {
            throw new ConnectionException("Parameter service is missing in config");
        }
        ServiceModel serviceModel = this.getWsdlModel().getService(this.service);
        if (serviceModel == null) {
            throw new ConnectionException(String.format("The service name '%s' was not found in the current wsdl file.", this.service));
        }
        return serviceModel;
    }

    public PortModel getPortModel() throws ConnectionException {
        if (StringUtils.isBlank((String)this.port)) {
            throw new ConnectionException("Parameter port is missing in config");
        }
        PortModel portModel = this.getServiceModel().getPort(this.port);
        if (portModel == null) {
            throw new ConnectionException(String.format("The port name '%s' was not found in the current wsdl file.", this.port));
        }
        return portModel;
    }

    private WsdlParser getWsdlParser() throws ConnectionException {
        if (this.wsdlParser != null) {
            return this.wsdlParser;
        }
        String locationURL = this.getWsdlLocationUrl().toString();
        try {
            this.wsdlParser = WsdlParser.Companion.instance(locationURL, "UTF-8");
            return this.wsdlParser;
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Error parsing WSDL file '%s'", locationURL), (Throwable)e);
        }
    }

    public PortModel validate() throws ConnectionException {
        this.getWsdlModel();
        this.getServiceModel();
        return this.getPortModel();
    }
}

