/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.ValuePart;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class WsdlConnectionInfo {
    private static final String ROOT_API = "api/";
    @Placement(order=1)
    @Parameter
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"wsdl"}, acceptsUrls=true)
    private String wsdlLocation;
    @Placement(order=2)
    @Parameter
    @ValuePart(order=1)
    private String service;
    @Placement(order=3)
    @Parameter
    @ValuePart(order=2)
    private String port;
    private WsdlParser wsdlParser = null;
    private XmlTypeLoader typeLoader = null;

    public String getService() {
        return this.service;
    }

    public String getPort() {
        return this.port;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public WsdlModel getWsdlModel() throws ConnectionException {
        return this.getWsdlParser().getWsdl();
    }

    public XmlTypeLoader getXmlTypeLoader() throws ConnectionException {
        if (this.typeLoader == null) {
            SchemaCollector schemas = SchemaCollector.getInstance();
            this.getWsdlParser().collectSchemas().forEach((arg_0, arg_1) -> ((SchemaCollector)schemas).addSchema(arg_0, arg_1));
            this.typeLoader = new XmlTypeLoader(schemas);
        }
        return this.typeLoader;
    }

    public URL getWsdlLocationUrl() throws ConnectionException {
        return WsdlConnectionInfo.getWsdlLocationUrl(this.wsdlLocation);
    }

    public ServiceModel getServiceModel() throws ConnectionException {
        WsdlModel wsdlModel = this.getWsdlModel();
        if (StringUtils.isBlank((String)this.service)) {
            throw new ConnectionException("Parameter service is missing in config");
        }
        ServiceModel serviceModel = wsdlModel.getService(this.service);
        if (serviceModel == null) {
            throw new ConnectionException(String.format("The service name '%s' was not found in the current wsdl file.", this.service));
        }
        return serviceModel;
    }

    public PortModel getPortModel() throws ConnectionException {
        if (StringUtils.isBlank((String)this.port)) {
            throw new ConnectionException("Parameter port is missing in config");
        }
        PortModel portModel = this.getServiceModel().getPort(this.port);
        if (portModel == null) {
            throw new ConnectionException(String.format("The port name '%s' was not found in the current wsdl file.", this.port));
        }
        return portModel;
    }

    public static WsdlModel getWsdlModel(String wsdlLocation) throws ConnectionException {
        if (StringUtils.isBlank((String)wsdlLocation)) {
            throw new ConnectionException("Parameter wsdlLocation is missing in config");
        }
        URL wsdlUrl = WsdlConnectionInfo.getWsdlLocationUrl(wsdlLocation);
        try {
            String location = wsdlUrl.toString();
            return WsdlParser.Companion.parse(location);
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Error parsing WSDL file '%s'", wsdlUrl.toString()), (Throwable)e);
        }
    }

    public static URL getWsdlLocationUrl(String wsdlLocation) throws ConnectionException {
        Optional<URL> url = WsdlConnectionInfo.getUrl(wsdlLocation);
        if (url.isPresent()) {
            return url.get();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(wsdlLocation);
        if (resource == null) {
            resource = classLoader.getResource(ROOT_API + wsdlLocation);
        }
        if (resource == null) {
            throw new ConnectionException(String.format("Cannot create URL for wsdlLocation '%s' in config [%s]", wsdlLocation, classLoader.getClass().getName()));
        }
        return resource;
    }

    private static Optional<URL> getUrl(String wsdlLocation) {
        try {
            URL url = new URL(wsdlLocation);
            return Optional.of(url);
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
    }

    private WsdlParser getWsdlParser() throws ConnectionException {
        if (this.wsdlParser != null && !this.wsdlParser.getWsdl().getLocation().equals(this.wsdlLocation)) {
            this.wsdlParser = null;
        }
        if (this.wsdlParser == null) {
            this.wsdlParser = WsdlConnectionInfo.getWsdlParser(this.wsdlLocation);
        }
        return this.wsdlParser;
    }

    public static WsdlParser getWsdlParser(String wsdlLocation) throws ConnectionException {
        if (StringUtils.isBlank((String)wsdlLocation)) {
            throw new ConnectionException("Parameter wsdlLocation is missing in config");
        }
        URL wsdlUrl = WsdlConnectionInfo.getWsdlLocationUrl(wsdlLocation);
        try {
            String location = wsdlUrl.toString();
            return WsdlParser.Companion.instance(location, "UTF-8");
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Error parsing WSDL file '%s'", wsdlUrl), (Throwable)e);
        }
    }

    public PortModel validate() throws ConnectionException {
        this.getWsdlModel();
        this.getServiceModel();
        return this.getPortModel();
    }
}

