/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal.values;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.module.soapkit.internal.WsdlConnectionInfo;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class WsdlValueProvider
implements ValueProvider {
    @Parameter
    private String wsdlLocation;

    public Set<Value> resolve() throws ValueResolvingException {
        try {
            WsdlModel wsdlModel = WsdlConnectionInfo.getWsdlModel(this.wsdlLocation);
            List services = wsdlModel.getServices();
            return this.serviceValues(services);
        }
        catch (ConnectionException e) {
            throw new ValueResolvingException(String.format("Unable to resolve values for wsdlLocation '%s'", this.wsdlLocation), "INVALID_LOCATION", (Throwable)e);
        }
    }

    private Set<Value> serviceValues(List<ServiceModel> services) {
        HashSet<Value> values = new HashSet<Value>();
        for (ServiceModel service : services) {
            ValueBuilder serviceBuilder = ValueBuilder.newValue((String)service.getName());
            this.portValues(service.getPorts()).forEach(arg_0 -> ((ValueBuilder)serviceBuilder).withChild(arg_0));
            values.add(serviceBuilder.build());
        }
        return values;
    }

    private Set<ValueBuilder> portValues(List<PortModel> ports) {
        return ports.stream().map(port -> {
            ValueBuilder portBuilder = ValueBuilder.newValue((String)port.getName());
            String address = port.getAddress();
            if (address != null) {
                portBuilder.withChild(ValueBuilder.newValue((String)address));
            }
            return portBuilder;
        }).collect(Collectors.toSet());
    }
}

