/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapRequestBuilder;
import org.mule.soapkit.soap.api.server.SoapServerHandler;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.util.Cast;
import org.mule.soapkit.soap.util.XmlTransformationException;
import org.mule.soapkit.soap.util.XmlTransformationUtils;

class SoapCxfInvoker
implements Invoker {
    SoapCxfInvoker() {
    }

    public Object invoke(Exchange exchange, Object o) {
        try {
            SoapServerHandler serverHandler = (SoapServerHandler)Cast.cast(exchange.get((Object)"mule.soap.server.handler"));
            XMLStreamReader payload = this.extractPayload(exchange);
            Map<String, String> soapHeader = this.extractHeaders(exchange);
            Map<String, SoapAttachment> attachments = this.extractAttachments(exchange);
            Map<String, String> transportHeaders = this.extractTransportHeaders(exchange);
            BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            String operation = bop.getOperationInfo().getName().getLocalPart();
            MediaType contentType = this.getContentType(transportHeaders);
            SoapRequestBuilder builder = SoapRequest.builder().operation(operation).contentType(contentType).soapHeaders(soapHeader).attachments(attachments).transportHeaders(transportHeaders).content(this.xmlStreamReaderToInputStream(payload));
            try {
                SoapResponse response = serverHandler.handle((SoapRequest)builder.build());
                exchange.put((Object)"mule.soap.server.response", (Object)response);
                return new Object[]{response};
            }
            catch (Throwable throwable) {
                throw Exceptions.rxExceptionToMuleException((Throwable)throwable);
            }
        }
        catch (Throwable t) {
            Fault fault = this.findFaultException(t);
            if (fault != null) {
                throw fault;
            }
            throw new Fault(t);
        }
    }

    private MediaType getContentType(Map<String, String> transportHeaders) {
        Charset charset = transportHeaders.keySet().stream().filter("Content-Type"::equalsIgnoreCase).findAny().map(transportHeaders::get).flatMap(s -> MediaType.parse((String)s).getCharset()).orElseGet(Charset::defaultCharset);
        return MediaType.APPLICATION_XML.withCharset(charset);
    }

    private Fault findFaultException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Fault) {
            return (Fault)e;
        }
        return this.findFaultException(e.getCause());
    }

    private Map<String, SoapAttachment> extractAttachments(Exchange exchange) {
        return (Map)Cast.cast(exchange.get((Object)"mule.soap.attachments"));
    }

    private Map<String, String> extractTransportHeaders(Exchange exchange) {
        Map headers = (Map)Cast.cast(exchange.getInMessage().get((Object)Message.PROTOCOL_HEADERS));
        return headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).isEmpty() ? "" : (String)((List)e.getValue()).get(0)));
    }

    private Map<String, String> extractHeaders(Exchange exchange) {
        return (Map)Cast.cast(exchange.get((Object)"mule.soap.headers"));
    }

    private XMLStreamReader extractPayload(Exchange exchange) {
        return (XMLStreamReader)exchange.getInMessage().getContent(XMLStreamReader.class);
    }

    private InputStream xmlStreamReaderToInputStream(XMLStreamReader reader) {
        try {
            return XmlTransformationUtils.xmlStreamReaderToInputStream(reader);
        }
        catch (XmlTransformationException e) {
            throw new BadRequestException("Error transforming the soap request to be processed", (Throwable)e);
        }
    }
}

