/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.service.factory.ReflectionServiceFactoryBean;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.soapkit.soap.api.server.SoapServerConfiguration;
import org.mule.soapkit.soap.server.ProxyService;
import org.mule.soapkit.soap.server.ProxyServiceConfiguration;
import org.mule.soapkit.soap.server.SoapServerMessages;

class ProxyServiceFactoryBean
extends ReflectionServiceFactoryBean {
    private static final String WSDL_LOCATION = "WSDL_LOCATION";
    private static final String INVOKE = "invoke";
    private static final Logger LOG = LogUtils.getLogger(ProxyServiceFactoryBean.class);
    private static ProxyServiceConfiguration proxyServiceConfiguration;

    ProxyServiceFactoryBean(SoapServerConfiguration config) {
        this.setWsdlURL(config.getWsdlLocation().toString());
        proxyServiceConfiguration = new ProxyServiceConfiguration(config);
        this.getServiceConfigurations().add(0, proxyServiceConfiguration);
        ArrayList<String> ignoredClasses = new ArrayList<String>();
        ignoredClasses.add("java.lang.Object");
        ignoredClasses.add("java.lang.Throwable");
        ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        ignoredClasses.add("javax.ejb.EJBObject");
        ignoredClasses.add("javax.rmi.CORBA.Stub");
        this.setIgnoredClasses(ignoredClasses);
    }

    protected void initializeWSDLOperations() {
        if (this.getServiceClass().isAssignableFrom(ProxyService.class)) {
            this.initializeWSDLOperationsForProvider();
        } else {
            super.initializeWSDLOperations();
        }
    }

    private void initializeWSDLOperationsForProvider() {
        Class<Source> c = Source.class;
        if (this.getEndpointInfo() == null && this.isFromWsdl()) {
            ArrayList<QName> enames = new ArrayList<QName>();
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (EndpointInfo ep : si.getEndpoints()) {
                    enames.add(ep.getName());
                }
            }
            I18nMessage i18nMessage = SoapServerMessages.couldNotFindEndpoint(this.getEndpointName(), enames);
            LOG.log(Level.WARNING, i18nMessage.getMessage(), new WSDLException(String.valueOf(i18nMessage.getCode()), i18nMessage.getMessage()));
        }
        try {
            this.getEndpointInfo().getService().setProperty(WSDL_LOCATION, (Object)this.getWsdlURL());
            Method invoke = this.getServiceClass().getMethod(INVOKE, c);
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (OperationInfo o : si.getInterface().getOperations()) {
                    this.getMethodDispatcher().bind(o, new Method[]{invoke});
                }
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
    }
}

