/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl.service.factory.DefaultServiceConfiguration;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.soapkit.soap.api.server.SoapServerConfiguration;
import org.mule.soapkit.soap.server.SoapServerMessages;

class ProxyServiceConfiguration
extends DefaultServiceConfiguration {
    private static final Logger LOG = LogUtils.getLogger(ProxyServiceConfiguration.class);
    private SoapVersion soapVersion;
    private String portName;

    public ProxyServiceConfiguration(SoapServerConfiguration config) {
        this.portName = config.getPort();
        this.soapVersion = config.getVersion();
    }

    public QName getEndpointName() {
        try {
            if (this.getServiceFactory().getWsdlURL() != null) {
                Definition definition = ((WSDLManager)this.getServiceFactory().getBus().getExtension(WSDLManager.class)).getDefinition(this.getServiceFactory().getWsdlURL());
                Service service = this.getServiceFromDefinition(definition);
                this.setServiceNamespace(service.getQName().getNamespaceURI());
                QName endpointName = this.portName != null ? new QName(this.getServiceNamespace(), this.portName) : new QName(this.getServiceNamespace(), ((Port)service.getPorts().values().iterator().next()).getName());
                LOG.fine(String.format("ProxyServiceConfiguration using endpoint %s", endpointName));
                return endpointName;
            }
            return super.getEndpointName();
        }
        catch (WSDLException e) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), (Throwable)e);
        }
    }

    private Service getServiceFromDefinition(Definition definition) throws WSDLException {
        Service service = definition.getService(this.getServiceFactory().getServiceQName());
        if (service == null) {
            List<QName> probableServices = this.getProbableServices(definition);
            List<QName> allServices = this.getAllServices(definition);
            I18nMessage message = SoapServerMessages.invalidOrMissingNamespace(this.getServiceFactory().getServiceQName(), probableServices, allServices);
            throw new WSDLException(String.valueOf(message.getCode()), message.getMessage());
        }
        return service;
    }

    private List<QName> getAllServices(Definition definition) {
        return new LinkedList<QName>(CollectionUtils.select(definition.getServices().keySet(), object -> object instanceof QName));
    }

    private List<QName> getProbableServices(Definition definition) {
        QName serviceQName = this.getServiceFactory().getServiceQName();
        LinkedList<QName> probableServices = new LinkedList<QName>();
        Map services = definition.getServices();
        for (Object key : services.keySet()) {
            QName qNameKey;
            if (!(key instanceof QName) || (qNameKey = (QName)key).getLocalPart() == null || !qNameKey.getLocalPart().equals(serviceQName.getLocalPart())) continue;
            probableServices.add(qNameKey);
        }
        return probableServices;
    }
}

