/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.message;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.soapkit.soap.util.Cast;

public class SubFlowResponse {
    private static final String BODY = "body";
    private static final String HEADERS = "headers";
    private static final String ATTACHMENTS = "attachments";
    private static final String CONTENT_TYPE = "contentType";
    private static final String CONTENT = "content";
    private final InputStream body;
    private final Map<String, String> headers;
    private final Map<String, SoapAttachment> attachments;

    private SubFlowResponse(InputStream body, Map<String, String> headers, Map<String, SoapAttachment> attachments) {
        this.body = body;
        this.headers = headers;
        this.attachments = attachments;
    }

    public InputStream getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public static SubFlowResponse create(Map map, Charset charset) {
        InputStream body = SubFlowResponse.createBody(map.get(BODY), charset);
        Map<String, String> headers = SubFlowResponse.createHeaders(map.get(HEADERS));
        Map<String, SoapAttachment> attachments = SubFlowResponse.createAttachments(map.get(ATTACHMENTS));
        return new SubFlowResponse(body, headers, attachments);
    }

    public static SubFlowResponse createFromBody(InputStream body) {
        return new SubFlowResponse(body, Collections.emptyMap(), Collections.emptyMap());
    }

    private static InputStream createBody(Object value, Charset charset) {
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        if (value instanceof String) {
            return IOUtils.toInputStream((String)((String)value), (Charset)charset);
        }
        throw new IllegalArgumentException("Invalid 'body' detected in payload");
    }

    private static Map<String, String> createHeaders(Object value) {
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)Cast.cast(value);
        }
        throw new IllegalArgumentException("Invalid 'headers' detected in payload");
    }

    private static Map<String, SoapAttachment> createAttachments(Object value) {
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            Map attachments = (Map)Cast.cast(value);
            LinkedHashMap<String, SoapAttachment> result = new LinkedHashMap<String, SoapAttachment>();
            attachments.forEach((key, object) -> {
                InputStream content;
                String attachmentName = (String)key;
                if (!(object instanceof Map)) {
                    throw new IllegalArgumentException("Invalid 'attachments' detected in payload. Problems with attachment '" + attachmentName + "'");
                }
                Map attachmentValue = (Map)Cast.cast(object);
                Object contentObject = attachmentValue.get(CONTENT);
                InputStream inputStream = contentObject instanceof InputStream ? (InputStream)contentObject : (content = contentObject instanceof String ? IOUtils.toInputStream((String)((String)contentObject)) : null);
                if (content == null) {
                    throw new IllegalArgumentException("Invalid 'attachments' detected in payload. Problems with attachment '" + attachmentName + "'");
                }
                String contentType = (String)attachmentValue.get(CONTENT_TYPE);
                SoapAttachment soapResponseAttachment = new SoapAttachment(content, MediaType.parse((String)contentType));
                result.put(attachmentName, soapResponseAttachment);
            });
            return result;
        }
        throw new IllegalArgumentException("Invalid 'attachments' detected in payload");
    }
}

