/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.api.server;

import java.net.URL;
import java.util.Map;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.soapkit.soap.api.param.ValidationLevel;
import org.mule.soapkit.soap.api.server.SoapServerConfigurationBuilder;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public final class SoapServerConfiguration {
    private final WsdlModel wsdlModel;
    private final URL wsdlLocation;
    private final String namespace;
    private final ServiceModel serviceModel;
    private final PortModel portModel;
    private final SoapVersion version;
    private final boolean mtomEnabled;
    private final boolean validationEnabled;
    private final ValidationLevel validationLevel;
    private final boolean payloadBody;
    private final Map<String, String> namespacePrefixes;

    SoapServerConfiguration(WsdlModel wsdlModel, URL wsdlLocation, String namespace, ServiceModel serviceModel, PortModel portModel, SoapVersion version, boolean mtomEnabled, boolean validationEnabled, boolean payloadBody, Map<String, String> namespacePrefixes) {
        this.wsdlModel = wsdlModel;
        this.wsdlLocation = wsdlLocation;
        this.namespace = namespace;
        this.serviceModel = serviceModel;
        this.portModel = portModel;
        this.version = version;
        this.mtomEnabled = mtomEnabled;
        this.validationEnabled = validationEnabled;
        this.payloadBody = payloadBody;
        this.namespacePrefixes = namespacePrefixes;
        this.validationLevel = ValidationLevel.WARN;
    }

    SoapServerConfiguration(WsdlModel wsdlModel, URL wsdlLocation, String namespace, ServiceModel serviceModel, PortModel portModel, SoapVersion version, boolean mtomEnabled, boolean validationEnabled, boolean payloadBody, Map<String, String> namespacePrefixes, ValidationLevel validationLevel) {
        this.wsdlModel = wsdlModel;
        this.wsdlLocation = wsdlLocation;
        this.namespace = namespace;
        this.serviceModel = serviceModel;
        this.portModel = portModel;
        this.version = version;
        this.mtomEnabled = mtomEnabled;
        this.validationEnabled = validationEnabled;
        this.payloadBody = payloadBody;
        this.namespacePrefixes = namespacePrefixes;
        this.validationLevel = validationLevel;
    }

    public static SoapServerConfigurationBuilder builder() {
        return new SoapServerConfigurationBuilder();
    }

    public URL getWsdlLocation() {
        return this.wsdlLocation;
    }

    public SoapVersion getVersion() {
        return this.version;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isPayloadBody() {
        return this.payloadBody;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getService() {
        return this.serviceModel.getName();
    }

    public String getPort() {
        return this.portModel.getName();
    }

    public PortModel getPortModel() {
        return this.portModel;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    public Map<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public ValidationLevel getValidationErrorLevel() {
        return this.validationLevel;
    }
}

