/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.message;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SoapAttributes {
    private static final long serialVersionUID = 4591210489306615571L;
    private final Map<String, String> protocolHeaders;
    private final Map<String, String> additionalTransportData;

    public SoapAttributes(Map<String, String> protocolHeaders, Map<String, String> additionalTransportData) {
        this.protocolHeaders = protocolHeaders != null ? ImmutableMap.copyOf(protocolHeaders) : ImmutableMap.of();
        this.additionalTransportData = additionalTransportData != null ? ImmutableMap.copyOf(additionalTransportData) : ImmutableMap.of();
    }

    public Map<String, String> getProtocolHeaders() {
        return this.protocolHeaders;
    }

    public Map<String, String> getAdditionalTransportData() {
        return this.additionalTransportData;
    }

    public String toString() {
        String headersAsString = this.protocolHeaders.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",\n    "));
        String transportDataAsString = this.additionalTransportData.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",\n    "));
        return "{\n  additionalTransportData = [\n    " + transportDataAsString + "\n  ]\n  protocolHeaders = [\n    " + headersAsString + "\n  ]\n}";
    }
}

