/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.scripting.operation;

import java.util.Map;
import javax.script.Bindings;
import org.mule.plugin.scripting.ExecutionMode;
import org.mule.plugin.scripting.component.ScriptRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.api.runtime.privileged.StreamingHelperFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ScriptingOperationExecutor
implements ComponentExecutor<OperationModel> {
    private ScriptRunner scriptRunner;
    private final Once.ConsumeOnce<ExecutionContextAdapter<OperationModel>> initScriptRunner = Once.of(this::initScriptRunner);
    private volatile StreamingHelper streamingHelper;

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        try {
            Map parameters = (Map)context.getParameter("parameters");
            ExecutionMode executionMode = (ExecutionMode)((Object)context.getParameter("executionMode"));
            if (executionMode == null) {
                executionMode = ExecutionMode.AUTO;
            }
            Result<Object, Object> result = this.process(context.getEvent(), parameters, (ExecutionContextAdapter<OperationModel>)context, executionMode);
            return Mono.justOrEmpty(result);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private void initScriptRunner(ExecutionContextAdapter<OperationModel> context) throws MuleException {
        String engine = (String)context.getParameter("engine");
        String code = (String)context.getParameter("code");
        this.scriptRunner = new ScriptRunner(engine, code, context.getComponent().getLocation());
        context.getMuleContext().getInjector().inject((Object)this.scriptRunner);
        this.scriptRunner.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<Object, Object> process(CoreEvent event, Map<String, Object> parameters, ExecutionContextAdapter<OperationModel> context, ExecutionMode executionMode) {
        this.initScriptRunner.consumeOnce(context);
        Bindings bindings = this.scriptRunner.getScriptEngine().createBindings();
        if (this.streamingHelper == null) {
            ScriptingOperationExecutor scriptingOperationExecutor = this;
            synchronized (scriptingOperationExecutor) {
                if (this.streamingHelper == null) {
                    this.streamingHelper = new StreamingHelperFactory().resolve(context);
                }
            }
        }
        this.scriptRunner.populateBindings(bindings, event, parameters, this.streamingHelper);
        try {
            Object result = this.scriptRunner.runScript(bindings, executionMode);
            if (result instanceof Message) {
                CoreEvent resultEvent = CoreEvent.builder((CoreEvent)event).message((Message)result).build();
                EventedResult eventedResult = EventedResult.from((CoreEvent)resultEvent);
                return eventedResult;
            }
            Result result2 = Result.builder((Message)event.getMessage()).attributes(null).output(result).mediaType(MediaType.APPLICATION_JAVA).build();
            return result2;
        }
        finally {
            this.scriptRunner.closeCursors(bindings);
            bindings.clear();
        }
    }
}

