/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.scripting.component;

import java.io.Closeable;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.mule.plugin.scripting.errors.ScriptingErrors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.privileged.el.context.SessionVariableMapContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.util.CollectionUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptRunner.class);
    private static final String BINDING_LOG = "log";
    private static final String BINDING_RESULT = "result";
    private static final String BINDING_SESSION_VARS = "sessionVars";
    private static final String REGISTRY = "registry";
    private String engineName;
    private String scriptBody;
    private ComponentLocation location;
    @Inject
    private Registry registry;
    private CompiledScript compiledScript;
    private ScriptEngine scriptEngine;
    private ScriptEngineManager scriptEngineManager;

    public ScriptRunner(String engine, String code, ComponentLocation location) {
        this.engineName = engine;
        this.scriptBody = code;
        this.location = location;
        this.initialise();
    }

    public void initialise() {
        block6: {
            this.scriptEngineManager = new ScriptEngineManager(this.getClass().getClassLoader());
            this.scriptEngine = this.createScriptEngineByName(this.engineName);
            if (this.scriptEngine == null) {
                String message = "Scripting engine '" + this.engineName + "' not found.  Available engines are: " + this.listAvailableEngines();
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)message), (ErrorTypeDefinition)ScriptingErrors.UNKNOWN_ENGINE);
            }
            StringReader script = new StringReader(this.scriptBody);
            try {
                if (!(this.scriptEngine instanceof Compilable)) break block6;
                try {
                    this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
                }
                catch (ScriptException e) {
                    throw new ModuleException((ErrorTypeDefinition)ScriptingErrors.COMPILATION, (Throwable)e);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)script);
            }
        }
    }

    public void populateDefaultBindings(Bindings bindings) {
        bindings.put(BINDING_LOG, (Object)LOGGER);
        bindings.put(BINDING_RESULT, (Object)null);
    }

    public void populateBindings(Bindings bindings, CoreEvent event, Map<String, Object> parameters) {
        for (Binding binding : BindingContextUtils.addEventBindings((Event)event, (BindingContext)BindingContextUtils.NULL_BINDING_CONTEXT).bindings()) {
            Object resolvedValue = this.resolveCursor(binding.value().getValue());
            bindings.put(binding.identifier(), resolvedValue);
        }
        if (this.registry.lookupByName("_compatibilityPluginInstalled").isPresent()) {
            bindings.put("message", (Object)event.getMessage());
            bindings.put(BINDING_SESSION_VARS, (Object)new SessionVariableMapContext(((PrivilegedEvent)event).getSession()));
        }
        bindings.put("vars", (Object)Collections.unmodifiableMap(this.createResolvedMap(event)));
        bindings.put("flow", (Object)this.location.getRootContainerName());
        bindings.put(REGISTRY, (Object)this.registry);
        bindings.putAll((Map<? extends String, ? extends Object>)parameters);
        this.populateDefaultBindings(bindings);
    }

    public Object runScript(Bindings bindings) {
        Object result;
        try {
            result = this.compiledScript != null ? this.compiledScript.eval(bindings) : this.scriptEngine.eval(this.scriptBody, bindings);
            if (result == null) {
                result = bindings.get(BINDING_RESULT);
            }
        }
        catch (Exception ex) {
            throw new ModuleException((ErrorTypeDefinition)ScriptingErrors.EXECUTION, (Throwable)ex);
        }
        return result;
    }

    protected ScriptEngine createScriptEngineByName(String name) {
        return this.scriptEngineManager.getEngineByName(name);
    }

    protected String listAvailableEngines() {
        return CollectionUtils.toString(this.scriptEngineManager.getEngineFactories(), (boolean)false);
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    private Object resolveCursor(Object value) {
        if (value instanceof CursorProvider) {
            value = ((CursorProvider)value).openCursor();
        }
        return value;
    }

    private Map<String, Object> createResolvedMap(CoreEvent event) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        event.getVariables().entrySet().forEach(e -> {
            Object value = this.resolveCursor(((TypedValue)e.getValue()).getValue());
            variables.put((String)e.getKey(), value);
        });
        return variables;
    }
}

