/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.sources;

import java.io.InputStream;
import org.mule.extension.api.routing.ListenerRequestAttributes;
import org.mule.extension.api.serialization.CollectionSuccessResponse;
import org.mule.extension.api.serialization.EntityCollectionSuccessResponse;
import org.mule.extension.internal.datasense.EntityCollectionKeyResolver;
import org.mule.extension.internal.datasense.OutputEntityCollectionResolver;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.SourceKind;
import org.mule.extension.internal.sources.BaseSource;
import org.mule.extension.internal.sources.SourceConfiguration;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MetadataScope(keysResolver=EntityCollectionKeyResolver.class, outputResolver=OutputEntityCollectionResolver.class)
@MediaType(value="*/*", strict=false)
@Alias(value="RequestEntityCollectionListener")
@DisplayName(value="On Entity Collection Request")
@EmitsResponse
public class EntityCollectionSource
extends BaseSource<InputStream, ListenerRequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityCollectionSource.class);

    @Override
    protected RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration> getRoutingKey() {
        return new RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration>(this.routingKey.getMethod(), this.routingKey.getPath(), SourceKind.ENTITY_COLLECTION);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @OnSuccess
    public void onSuccess(@Placement(tab="Responses") @NullSafe(defaultImplementingType=EntityCollectionSuccessResponse.class) @Optional CollectionSuccessResponse collectionSuccessResponse, SourceCallbackContext callbackContext, SourceCompletionCallback completionCallback) {
        if (!(collectionSuccessResponse instanceof EntityCollectionSuccessResponse)) {
            super.onSuccess(collectionSuccessResponse, callbackContext, completionCallback);
            return;
        }
        EntityCollectionSuccessResponse flowResult = (EntityCollectionSuccessResponse)collectionSuccessResponse;
        EntityCollectionSuccessResponse transformedSuccessResponse = new EntityCollectionSuccessResponse(this.convert(collectionSuccessResponse.getResponseContent(), InputStream.class, org.mule.runtime.api.metadata.MediaType.JSON), flowResult.getFlowResponseMetadataProperties(), flowResult.getSerializationParameters());
        super.onSuccess(transformedSuccessResponse, callbackContext, completionCallback);
    }
}

