/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.serialization.queryoptions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.mule.extension.api.serialization.SerializationParameters;
import org.mule.extension.internal.exception.NotImplementedException;
import org.mule.extension.internal.exception.SerializationException;
import org.mule.extension.internal.utils.URICoder;

@FunctionalInterface
public interface QueryOptionModifier {
    public void apply(EntityCollection var1);

    default public QueryOptionModifier appendNext(QueryOptionModifier queryOptionModifier) {
        return entityCollection -> {
            this.apply(entityCollection);
            queryOptionModifier.apply(entityCollection);
        };
    }

    public static QueryOptionModifier chainQueryOptionsModifier(QueryOptionModifier ... queryOptionModifiers) {
        Optional<QueryOptionModifier> reduce = Arrays.stream(queryOptionModifiers).filter(Objects::nonNull).reduce(QueryOptionModifier::appendNext);
        return reduce.orElse(QueryOptionModifier.empty());
    }

    public static QueryOptionModifier build(SerializationParameters serializationParameters, String rawRequestUri, UriInfo uriInfo) {
        if (StringUtils.isBlank((CharSequence)rawRequestUri) || uriInfo == null || serializationParameters == null) {
            return QueryOptionModifier.empty();
        }
        QueryOptionModifier countQueryOptionModifier = QueryOptionModifier.getCountQueryOptionModifier(uriInfo.getCountOption(), serializationParameters.getCount());
        QueryOptionModifier serverSidePaginationModifier = QueryOptionModifier.serverSidePaginationModifier(serializationParameters, rawRequestUri, uriInfo);
        return QueryOptionModifier.chainQueryOptionsModifier(countQueryOptionModifier, serverSidePaginationModifier);
    }

    public static QueryOptionModifier empty() {
        return entityCollection -> {};
    }

    public static QueryOptionModifier getCountQueryOptionModifier(CountOption countOption, Integer count) {
        if (countOption != null && countOption.getValue()) {
            if (count == null) {
                throw new NotImplementedException("Count query option is not implemented");
            }
            return entityCollection -> entityCollection.setCount(count);
        }
        return null;
    }

    public static QueryOptionModifier serverSidePaginationModifier(SerializationParameters serializationParameters, String rawRequestUri, UriInfo uriInfo) {
        String token = serializationParameters.getToken();
        if (token != null) {
            return entityCollection -> entityCollection.setNext(QueryOptionModifier.createNextLink(rawRequestUri, token));
        }
        return QueryOptionModifier.getSequentialServerSidePagingModifier(serializationParameters, uriInfo, rawRequestUri);
    }

    public static QueryOptionModifier getSequentialServerSidePagingModifier(SerializationParameters paginationParameters, UriInfo uriInfo, String rawRequestUri) {
        Integer pageSize = paginationParameters.getPageSize();
        if (pageSize == null) {
            return null;
        }
        Integer count = paginationParameters.getCount();
        return entityCollection -> {
            int size = entityCollection.getEntities().size();
            if (size > pageSize) {
                throw new SerializationException("The list returned from the flow is longer than the expected");
            }
            Integer skipTokenValue = (uriInfo.getSkipTokenOption() != null ? Integer.valueOf(uriInfo.getSkipTokenOption().getValue()) : 0) + pageSize;
            if (size == pageSize) {
                if (count != null) {
                    if (skipTokenValue < count) {
                        entityCollection.setNext(QueryOptionModifier.createNextLink(rawRequestUri, skipTokenValue.toString()));
                    }
                } else {
                    entityCollection.setNext(QueryOptionModifier.createNextLink(rawRequestUri, skipTokenValue.toString()));
                }
            }
        };
    }

    public static URI createNextLink(String rawRequestUri, String skipTokenValue) {
        try {
            String nextLink = rawRequestUri.contains("?") ? rawRequestUri.replaceAll("(\\$|%24)skiptoken=.+&?", "").replaceAll("(\\?|&)$", "") : rawRequestUri;
            String skipTokenQueryParam = String.format("%s=%s", SystemQueryOptionKind.SKIPTOKEN, skipTokenValue);
            String nextLinkWithSkipToken = nextLink.contains("?") ? String.format("%s&%s", nextLink, skipTokenQueryParam) : String.format("%s?%s", nextLink, skipTokenQueryParam);
            Integer indexOfQuestion = nextLinkWithSkipToken.indexOf("?");
            String uri = nextLinkWithSkipToken.substring(0, indexOfQuestion + 1);
            String encodedQueryString = URICoder.encode(nextLinkWithSkipToken.substring(indexOfQuestion + 1), new HashSet<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf('&'))));
            return new URI(uri + encodedQueryString);
        }
        catch (URISyntaxException e) {
            throw new SerializationException("Exception while constructing next link", e);
        }
    }
}

