/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.transformation;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.search.SearchBinary;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;
import org.apache.olingo.server.api.uri.queryoption.search.SearchUnaryOperatorKind;
import org.apache.olingo.server.core.uri.parser.search.SearchParser;
import org.mule.extension.api.transformation.SearchFieldsAsType;
import org.mule.extension.internal.exception.SQLTransformationException;
import org.mule.extension.internal.transformation.DelimitIdentifiers;
import org.mule.extension.internal.transformation.SQLPreparedStatementBuilder;

public class SearchMatchByEntrySQLTranslator {
    private final SearchParser searchParser = new SearchParser();
    private final DelimitIdentifiers delimitIdentifiers;
    private final SearchFieldsAsType searchFieldsAsType;

    public SearchMatchByEntrySQLTranslator(DelimitIdentifiers delimitIdentifiers, SearchFieldsAsType searchFieldsAsType) {
        this.delimitIdentifiers = delimitIdentifiers;
        this.searchFieldsAsType = searchFieldsAsType;
    }

    public String transformToSqlWhereClause(String rawSearch, List<String> entityFields, boolean strictFullTermMatch, SQLPreparedStatementBuilder preparedStatement) {
        try {
            SearchOption searchOption = this.searchParser.parse(rawSearch);
            return this.buildWhereClause(entityFields, searchOption, strictFullTermMatch, preparedStatement);
        }
        catch (Exception e) {
            throw new SQLTransformationException("An error occurred while generating SQL transformation for $search", e);
        }
    }

    private String buildWhereClause(List<String> entityFields, SearchOption searchOption, boolean strictFullTermMatch, SQLPreparedStatementBuilder preparedStatement) {
        return this.traverseSearchExpression(entityFields, searchOption.getSearchExpression(), strictFullTermMatch, "", preparedStatement);
    }

    private String traverseSearchExpression(List<String> entityFields, SearchExpression searchExpression, boolean strictFullTermMatch, String sqlSearch, SQLPreparedStatementBuilder preparedStatement) {
        if (searchExpression == null || entityFields == null || entityFields.isEmpty()) {
            return sqlSearch;
        }
        if (searchExpression.isSearchTerm()) {
            String prepStatementKey = this.getPrepStatementKey(searchExpression.asSearchTerm().getSearchTerm(), strictFullTermMatch, preparedStatement);
            return entityFields.stream().map(field -> this.getFieldComparison((String)field, prepStatementKey, false)).collect(Collectors.joining(" OR "));
        }
        if (searchExpression.isSearchUnary()) {
            String prepStatementKey = this.getPrepStatementKey(searchExpression.asSearchUnary().getOperand().getSearchTerm(), strictFullTermMatch, preparedStatement);
            return entityFields.stream().map(field -> this.getFieldComparison((String)field, prepStatementKey, SearchUnaryOperatorKind.NOT.equals((Object)searchExpression.asSearchUnary().getOperator()))).collect(Collectors.joining(" AND "));
        }
        if (searchExpression.isSearchBinary()) {
            SearchBinary searchBinary = searchExpression.asSearchBinary();
            return StringUtils.joinWith((String)" ", (Object[])new Object[]{"(" + this.traverseSearchExpression(entityFields, searchBinary.getLeftOperand(), strictFullTermMatch, sqlSearch, preparedStatement) + ")", searchBinary.getOperator().name(), "(" + this.traverseSearchExpression(entityFields, searchBinary.getRightOperand(), strictFullTermMatch, sqlSearch, preparedStatement) + ")"});
        }
        return sqlSearch;
    }

    private String getTermComparison(String term, boolean negateExpression) {
        return (negateExpression ? " NOT" : "") + " LIKE " + term;
    }

    private String getPrepStatementKey(String searchTerm, boolean strictFullTermMatch, SQLPreparedStatementBuilder preparedStatement) {
        String newTerm = !strictFullTermMatch ? "%" + searchTerm + "%" : searchTerm;
        return preparedStatement.getParameterKey(newTerm);
    }

    private String getFieldComparison(String field, String term, boolean negateExpression) {
        if (this.searchFieldsAsType == SearchFieldsAsType.PGSQL_TO_TEXT) {
            return String.format("CAST(%s AS %s)%s", this.delimitIdentifiers.delimit(field), this.searchFieldsAsType.getType(), this.getTermComparison(term, negateExpression));
        }
        return this.delimitIdentifiers.delimit(field) + this.getTermComparison(term, negateExpression);
    }
}

