/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.extension.api.error.ODataErrorDetail;
import org.mule.extension.api.error.ODataServerError;

public class ODataServerErrorBuilder {
    private int statusCode;
    private String serviceCode;
    private String message;
    private String target;
    private List<ODataErrorDetail> details;
    private Map<String, String> innerError;

    public static ODataServerErrorBuilder builder() {
        return new ODataServerErrorBuilder();
    }

    public static ODataServerError from(org.apache.olingo.server.api.ODataServerError serverError) {
        ODataServerErrorBuilder serverErrorBuilder = ODataServerErrorBuilder.builder().withStatusCode(serverError.getStatusCode()).withServiceCode(serverError.getCode()).withMessage(serverError.getMessage()).withTarget(serverError.getTarget()).withInnerError(serverError.getInnerError());
        if (serverError.getDetails() != null) {
            serverError.getDetails().forEach(detail -> serverErrorBuilder.withDetail(new ODataErrorDetail(detail.getCode(), detail.getMessage(), detail.getTarget())));
        }
        return serverErrorBuilder.build();
    }

    public ODataServerErrorBuilder withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ODataServerErrorBuilder withServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
        return this;
    }

    public ODataServerErrorBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public ODataServerErrorBuilder withTarget(String target) {
        this.target = target;
        return this;
    }

    public ODataServerErrorBuilder withDetail(ODataErrorDetail detail) {
        if (this.details == null) {
            this.details = new ArrayList<ODataErrorDetail>();
        }
        this.details.add(detail);
        return this;
    }

    public ODataServerErrorBuilder withInnerError(Map<String, String> innerError) {
        this.innerError = innerError;
        return this;
    }

    public ODataServerError build() {
        return new ODataServerError(this.statusCode, this.serviceCode, this.message, this.target, this.details, this.innerError);
    }
}

