/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model.builders;

import java.util.Collection;
import java.util.Map;
import org.apache.olingo.server.api.ODataRequest;
import org.mule.extension.api.constants.HttpMethod;
import org.mule.extension.api.constants.HttpScheme;
import org.mule.extension.api.routing.ODataHttpAttributes;
import org.mule.extension.internal.model.builders.BaseRequestBuilder;
import org.mule.runtime.api.util.MultiMap;

public class ODataHttpAttributesBuilder
extends BaseRequestBuilder<ODataHttpAttributes, ODataHttpAttributesBuilder> {
    private String rawBaseUri;
    private String rawRequestUri;
    private HttpMethod method;
    private MultiMap<String, String> headers;

    private ODataHttpAttributesBuilder() {
    }

    public static ODataHttpAttributesBuilder builder() {
        return new ODataHttpAttributesBuilder();
    }

    public static ODataHttpAttributes from(ODataRequest request) {
        Map allHeaders = request.getAllHeaders();
        MultiMap headers = new MultiMap();
        allHeaders.forEach((k, v) -> headers.put(k, (Collection)v));
        return ((ODataHttpAttributesBuilder)((ODataHttpAttributesBuilder)((ODataHttpAttributesBuilder)ODataHttpAttributesBuilder.builder().withHeaders((MultiMap<String, String>)headers).withMethod(HttpMethod.valueOf(request.getMethod().name().toUpperCase())).withRawBaseUri(request.getRawBaseUri()).withRawRequestUri(request.getRawRequestUri()).withRawODataPath(request.getRawODataPath())).withRawQueryPath(request.getRawQueryPath())).withScheme(HttpScheme.valueOf(request.getProtocol().toUpperCase()))).build();
    }

    public ODataHttpAttributesBuilder withHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public ODataHttpAttributesBuilder withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public ODataHttpAttributesBuilder withRawBaseUri(String rawBaseUri) {
        this.rawBaseUri = rawBaseUri;
        return this;
    }

    public ODataHttpAttributesBuilder withRawRequestUri(String rawRequestUri) {
        this.rawRequestUri = rawRequestUri;
        return this;
    }

    @Override
    protected ODataHttpAttributesBuilder getThis() {
        return this;
    }

    @Override
    public ODataHttpAttributes build() {
        return new ODataHttpAttributes(this.method, this.scheme, this.headers == null ? MultiMap.emptyMultiMap() : this.headers, this.rawQueryPath, this.rawRequestUri, this.rawODataPath, this.rawBaseUri);
    }
}

