/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.api.clientcredentials;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.oauth2.api.exception.OAuthClientErrors;
import org.mule.extension.oauth2.internal.AbstractGrantType;
import org.mule.extension.oauth2.internal.store.SimpleObjectStoreToMapAdapter;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;

@NoExtend
@NoInstantiate
public class ClientCredentialsGrantType
extends AbstractGrantType {
    @Parameter
    @Optional(defaultValue="false")
    private boolean encodeClientCredentialsInBody;
    private ClientCredentialsOAuthDancer dancer;

    @Override
    public final void doInitialize() throws InitialisationException {
        this.initTokenManager();
        OAuthClientCredentialsDancerBuilder dancerBuilder = this.oAuthService.clientCredentialsGrantTypeDancerBuilder(this.lockFactory, new SimpleObjectStoreToMapAdapter(this.tokenManager.getResolvedObjectStore()), this.expressionEvaluator);
        dancerBuilder.encodeClientCredentialsInBody(this.isEncodeClientCredentialsInBody());
        dancerBuilder.clientCredentials(this.getClientId(), this.getClientSecret());
        this.configureBaseDancer((OAuthDancerBuilder)dancerBuilder);
        this.dancer = (ClientCredentialsOAuthDancer)dancerBuilder.build();
        LifecycleUtils.initialiseIfNeeded((Object)this.getDancer());
    }

    public void authenticate(HttpRequestBuilder builder) throws MuleException {
        try {
            builder.addHeader("Authorization", this.buildAuthorizationHeaderContent((String)this.dancer.accessToken().get()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DefaultMuleException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DefaultMuleException(e.getCause());
        }
    }

    public boolean shouldRetry(Result<Object, HttpResponseAttributes> firstAttemptResult) throws MuleException {
        Boolean shouldRetryRequest = this.resolver.resolveExpression(this.getRefreshTokenWhen(), firstAttemptResult);
        if (shouldRetryRequest.booleanValue()) {
            try {
                this.dancer.refreshToken().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DefaultMuleException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new DefaultMuleException(e.getCause());
            }
        }
        return shouldRetryRequest;
    }

    public void retryIfShould(Result<Object, HttpResponseAttributes> firstAttemptResult, Runnable retryCallback, Runnable notRetryCallback) throws ModuleException {
        Boolean isUnauthorized = ((HttpResponseAttributes)firstAttemptResult.getAttributes().get()).getStatusCode() == 401;
        Boolean shouldRetryRequest = this.resolver.resolveExpression(this.getRefreshTokenWhen(), firstAttemptResult);
        if (shouldRetryRequest.booleanValue()) {
            try {
                this.dancer.refreshToken().get();
                retryCallback.run();
            }
            catch (Exception ex) {
                throw new ModuleException((ErrorTypeDefinition)OAuthClientErrors.TOKEN_URL_FAIL, ex.getCause());
            }
        } else if (isUnauthorized.booleanValue()) {
            try {
                this.dancer.refreshToken().get();
            }
            catch (Exception ex) {
                throw new ModuleException((ErrorTypeDefinition)OAuthClientErrors.TOKEN_URL_FAIL, ex.getCause());
            }
        } else {
            notRetryCallback.run();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ClientCredentialsGrantType) {
            ClientCredentialsGrantType other = (ClientCredentialsGrantType)obj;
            return this.encodeClientCredentialsInBody == other.encodeClientCredentialsInBody && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.encodeClientCredentialsInBody);
    }

    public ClientCredentialsOAuthDancer getDancer() {
        return this.dancer;
    }

    @Override
    public boolean isEncodeClientCredentialsInBody() {
        return this.encodeClientCredentialsInBody;
    }

    public void setEncodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        this.encodeClientCredentialsInBody = encodeClientCredentialsInBody;
    }
}

