/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal;

import java.util.Objects;
import org.mule.extension.oauth2.api.tokenmanager.TokenManagerConfig;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class OAuthOperations {
    public void invalidateOauthContext(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        tokenManager.getConfigOAuthContext().clearContextForResourceOwner(resourceOwnerId);
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveAccessToken(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getAccessToken();
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveRefreshToken(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getRefreshToken();
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveExpiresIn(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getExpiresIn();
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveState(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getState();
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveCustomTokenResponseParam(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId, String key) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getTokenResponseParameters().get(key).toString();
    }

    private void validateResourceOwnerId(String resourceOwnerId) {
        Objects.requireNonNull(resourceOwnerId, "Resource owner id cannot be null");
    }

    private ResourceOwnerOAuthContext getContextForResourceOwner(TokenManagerConfig tokenManager, String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        return tokenManager.getConfigOAuthContext().getContextForResourceOwner(resourceOwnerId);
    }
}

