/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.api.tokenmanager;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.extension.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.extension.oauth2.internal.store.SimpleObjectStoreToMapAdapter;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

@Alias(value="token-manager-config")
@TypeDsl(allowTopLevelDefinition=true)
@NoExtend
@NoInstantiate
public class TokenManagerConfig<CTX extends ResourceOwnerOAuthContext & Serializable>
implements Lifecycle {
    public static AtomicInteger defaultTokenManagerConfigIndex = new AtomicInteger(0);
    private static final Map<String, TokenManagerConfig> activeConfigs = new ConcurrentHashMap<String, TokenManagerConfig>();
    @RefName
    private String name;
    @Parameter
    @Optional
    @ObjectStoreReference
    private ObjectStore<CTX> objectStore;
    private ObjectStore<CTX> resolvedObjectStore;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private ObjectStoreManager objectStoreManager;
    private ConfigOAuthContext configOAuthContext;
    private boolean initialised;
    private boolean started;

    public ObjectStore<CTX> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore<CTX> objectStore) {
        this.objectStore = objectStore;
    }

    public ObjectStore<CTX> getResolvedObjectStore() {
        return this.resolvedObjectStore;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialised) {
            return;
        }
        this.resolvedObjectStore = this.objectStore == null ? this.objectStoreManager.getOrCreateObjectStore("token-manager-store-" + this.name, ObjectStoreSettings.builder().persistent(true).build()) : this.objectStore;
        this.configOAuthContext = new ConfigOAuthContext(this.lockFactory, (Map<String, ResourceOwnerOAuthContext>)((Object)new SimpleObjectStoreToMapAdapter<CTX>(this.resolvedObjectStore)), this.name);
        this.initialised = true;
    }

    public void start() throws MuleException {
        if (!this.started) {
            LifecycleUtils.startIfNeeded(this.resolvedObjectStore);
            this.started = true;
        }
    }

    public void stop() throws MuleException {
        if (this.started) {
            LifecycleUtils.stopIfNeeded(this.resolvedObjectStore);
            this.started = false;
        }
    }

    public void dispose() {
        if (!this.initialised) {
            return;
        }
        this.configOAuthContext = null;
        activeConfigs.remove(this.name);
        this.initialised = false;
    }

    public static TokenManagerConfig createDefault() {
        TokenManagerConfig tokenManagerConfig = new TokenManagerConfig();
        String tokenManagerConfigName = "default-token-manager-config-" + defaultTokenManagerConfigIndex.getAndIncrement();
        tokenManagerConfig.setName(tokenManagerConfigName);
        activeConfigs.put(tokenManagerConfigName, tokenManagerConfig);
        return tokenManagerConfig;
    }

    public static TokenManagerConfig getTokenManagerConfigByName(String name) {
        return activeConfigs.get(name);
    }

    public ConfigOAuthContext getConfigOAuthContext() {
        return this.configOAuthContext;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenManagerConfig) {
            TokenManagerConfig other = (TokenManagerConfig)obj;
            return this.name.equals(other.name) && this.resolvedObjectStore == other.resolvedObjectStore;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resolvedObjectStore);
    }
}

