/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer.datatype;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Collection;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.util.ClassUtils;

public class CollectionDataTypeXStreamConverter
implements Converter {
    public boolean canConvert(Class type) {
        return CollectionDataType.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        DefaultCollectionDataType dataType = (DefaultCollectionDataType)source;
        writer.addAttribute("type", dataType.getType().getName());
        writer.addAttribute("mediaType", dataType.getMediaType().toRfcString());
        writer.addAttribute("itemType", dataType.getType().getName());
        writer.addAttribute("itemMediaType", dataType.getMediaType().toRfcString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class itemType;
        Class type;
        try {
            type = ClassUtils.getClass((String)reader.getAttribute("type"));
            itemType = ClassUtils.getClass((String)reader.getAttribute("itemType"));
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        String mediaType = reader.getAttribute("mediaType");
        String itemMediaType = reader.getAttribute("itemMediaType");
        return this.createDataType(type, mediaType, itemType, itemMediaType);
    }

    protected CollectionDataType createDataType(Class<? extends Collection> type, String mimeType, Class<?> itemType, String itemMediaType) {
        return (CollectionDataType)DataType.builder().collectionType(type).itemType(itemType).itemMediaType(itemMediaType).mediaType(mimeType).build();
    }
}

