/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.SAXContentHandler;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.module.xml.transformer.AbstractXmlTransformer;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

public class XmlToDomDocument
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public XmlToDomDocument() {
        this.setReturnDataType(DataType.builder().type(Document.class).build());
    }

    public Object transformMessage(Event event, Charset encoding) throws TransformerException {
        Object src = event.getMessage().getPayload().getValue();
        try {
            DocumentResult dr;
            ContentHandler contentHandler;
            Result result;
            Source sourceDoc = XMLUtils.toXmlSource(this.getXMLInputFactory(), this.isUseStaxSource(), src);
            if (sourceDoc == null) {
                return null;
            }
            if (XMLStreamReader.class.isAssignableFrom(this.getReturnDataType().getType())) {
                return this.getXMLInputFactory().createXMLStreamReader(sourceDoc);
            }
            if (this.getReturnDataType().getType().isAssignableFrom(sourceDoc.getClass())) {
                return sourceDoc;
            }
            AbstractXmlTransformer.ResultHolder holder = XmlToDomDocument.getResultHolder(this.getReturnDataType().getType());
            if (holder == null) {
                holder = XmlToDomDocument.getResultHolder(Document.class);
            }
            if ((result = holder.getResult()) instanceof DocumentResult && (contentHandler = (dr = (DocumentResult)holder.getResult()).getHandler()) instanceof SAXContentHandler) {
                ((SAXContentHandler)contentHandler).setMergeAdjacentText(true);
            }
            Transformer idTransformer = XMLUtils.getTransformer();
            idTransformer.setOutputProperty("encoding", encoding.name());
            idTransformer.transform(sourceDoc, holder.getResult());
            return holder.getResultObject();
        }
        catch (Exception e) {
            throw new TransformerException((org.mule.runtime.core.api.transformer.Transformer)this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

