/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DocumentResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.module.xml.transformer.DelayedResult;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractXmlTransformer
extends AbstractMessageTransformer
implements Initialisable {
    private String outputEncoding;
    private XMLInputFactory xmlInputFactory;
    private XMLOutputFactory xmlOutputFactory;
    private boolean useStaxSource = false;
    private boolean acceptExternalEntities = false;
    private boolean expandInternalEntities = false;

    public AbstractXmlTransformer() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.fromType(Source.class));
        this.registerSourceType(DataType.fromType(InputSource.class));
        this.registerSourceType(DataType.fromType(Node.class));
        this.registerSourceType(DataType.fromType(Document.class));
        this.registerSourceType(DataType.fromType(org.w3c.dom.Document.class));
        this.registerSourceType(DataType.fromType(Element.class));
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.fromType(OutputHandler.class));
        this.registerSourceType(DataType.fromType(XMLStreamReader.class));
        this.registerSourceType(DataType.fromType(DelayedResult.class));
        this.setReturnDataType(DataType.builder().type(byte[].class).mediaType(MediaType.XML).build());
    }

    public final void initialise() throws InitialisationException {
        this.xmlInputFactory = XMLSecureFactories.createWithConfig((Boolean)this.acceptExternalEntities, (Boolean)this.expandInternalEntities).getXMLInputFactory();
        this.useStaxSource = !this.acceptExternalEntities || !this.expandInternalEntities;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected static ResultHolder getResultHolder(Class<?> desiredClass) {
        if (desiredClass == null) {
            return null;
        }
        if (byte[].class.equals(desiredClass) || InputStream.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult((OutputStream)this.resultStream);

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.resultStream.toByteArray();
                }
            };
        }
        if (String.class.equals(desiredClass)) {
            return new ResultHolder(){
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(this.writer);

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.writer.getBuffer().toString();
                }
            };
        }
        if (org.w3c.dom.Document.class.isAssignableFrom(desiredClass)) {
            DOMResult result;
            try {
                DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
                result = new DOMResult(factory.newDocumentBuilder().newDocument());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create result document"), (Throwable)e);
            }
            return new ResultHolder(){

                @Override
                public Result getResult() {
                    return result;
                }

                @Override
                public Object getResultObject() {
                    return result.getNode();
                }
            };
        }
        if (DocumentResult.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.result;
                }
            };
        }
        if (Document.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.result.getDocument();
                }
            };
        }
        return null;
    }

    @Deprecated
    protected String convertToText(Object obj) throws Exception {
        return this.convertToText(obj, null);
    }

    protected String convertToText(Object obj, Charset outputEncoding) throws Exception {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Node) {
            return ((Node)obj).asXML();
        }
        Source src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
        if (src == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
        if (outputEncoding != null) {
            idTransformer.setOutputProperty("encoding", outputEncoding.name());
        }
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected String convertToBytes(Object obj, Charset outputEncoding) throws Exception {
        Source src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
        if (src == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding.name());
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected void writeToStream(Object obj, Charset outputEncoding, OutputStream output) throws Exception {
        Source src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
        if (src == null) {
            return;
        }
        StreamResult result = new StreamResult(output);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding.name());
        idTransformer.transform(src, result);
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean isUseStaxSource() {
        return this.useStaxSource;
    }

    public void setUseStaxSource(boolean useStaxSource) {
        this.useStaxSource = useStaxSource;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this.xmlInputFactory;
    }

    public void setXMLInputFactory(XMLInputFactory xmlInputFactory) {
        this.xmlInputFactory = xmlInputFactory;
    }

    public XMLOutputFactory getXMLOutputFactory() {
        return this.xmlOutputFactory;
    }

    public void setXMLOutputFactory(XMLOutputFactory xmlOutputFactory) {
        this.xmlOutputFactory = xmlOutputFactory;
    }

    public void setAcceptExternalEntities(boolean acceptExternalEntities) {
        this.acceptExternalEntities = acceptExternalEntities;
    }

    public void setExpandInternalEntities(boolean expandInternalEntities) {
        this.expandInternalEntities = expandInternalEntities;
    }

    protected static interface ResultHolder {
        public Result getResult();

        public Object getResultObject();
    }
}

