/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.module.xml.stax.ReversibleXMLStreamReader;
import org.mule.runtime.module.xml.transformer.AbstractXmlTransformer;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.w3c.dom.Document;

public class XmlToXMLStreamReader
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;
    private boolean reversible;

    public XmlToXMLStreamReader() {
        this.registerSourceType(DataType.fromType(Source.class));
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.fromType(Document.class));
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.STRING);
        this.setReturnDataType(DataType.fromType(XMLStreamReader.class));
    }

    public Object transformMessage(Event event, Charset encoding) throws TransformerException {
        Object src = event.getMessage().getPayload().getValue();
        try {
            XMLStreamReader xsr = XMLUtils.toXMLStreamReader(this.getXMLInputFactory(), src);
            if (xsr == null) {
                throw new TransformerException(I18nMessageFactory.createStaticMessage((String)("Unable to convert " + src.getClass() + " to XMLStreamReader.")), (Transformer)this);
            }
            if (this.reversible && !(xsr instanceof ReversibleXMLStreamReader)) {
                return new ReversibleXMLStreamReader(xsr);
            }
            return xsr;
        }
        catch (XMLStreamException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

