/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.dom4j.Document;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.AbstractXStreamTransformer;
import org.mule.module.xml.transformer.DomDocumentToXml;
import org.mule.util.store.DeserializationPostInitialisable;

public class XmlToObject
extends AbstractXStreamTransformer {
    private final DomDocumentToXml domTransformer = new DomDocumentToXml();

    public XmlToObject() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Document.class);
        this.setReturnClass(Object.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object result;
        Object src = message.getPayload();
        if (src instanceof byte[]) {
            try {
                InputStreamReader xml = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])src), outputEncoding);
                result = this.getXStream().fromXML((Reader)xml);
            }
            catch (UnsupportedEncodingException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
        if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                InputStreamReader xml = new InputStreamReader(input, outputEncoding);
                result = this.getXStream().fromXML((Reader)xml);
            }
            catch (Exception e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"Exception closing stream: ", (Throwable)e);
                }
            }
        }
        result = src instanceof String ? this.getXStream().fromXML(src.toString()) : this.getXStream().fromXML((String)this.domTransformer.transform(src));
        try {
            this.postDeserialisationInit(result);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected void postDeserialisationInit(final Object object) throws Exception {
        if (object instanceof DeserializationPostInitialisable) {
            try {
                final Method m = object.getClass().getDeclaredMethod("initAfterDeserialisation", MuleContext.class);
                Object o = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            m.setAccessible(true);
                            m.invoke(object, XmlToObject.this.muleContext);
                            return null;
                        }
                        catch (Exception e) {
                            return e;
                        }
                    }
                });
                if (o != null) {
                    throw (Exception)o;
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Object " + object.getClass() + " implements " + DeserializationPostInitialisable.class + " but does not have a method " + "private void initAfterDeserialisation(MuleContext) defined", e);
            }
        }
    }
}

