/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.routing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.module.xml.util.XMLUtils;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.util.ExceptionUtils;
import org.mule.util.StringUtils;

public class FilteringXmlMessageSplitter
extends AbstractMessageSplitter {
    protected final ThreadLocal propertiesContext = new ThreadLocal();
    protected final ThreadLocal nodesContext = new ThreadLocal();
    protected volatile String splitExpression = "";
    protected volatile Map namespaces = null;
    protected volatile boolean validateSchema = false;
    protected volatile String externalSchemaLocation = "";

    public void setSplitExpression(String splitExpression) {
        this.splitExpression = StringUtils.trimToEmpty((String)splitExpression);
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public Map getNamespaces() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    public String getSplitExpression() {
        return this.splitExpression;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public String getExternalSchemaLocation() {
        return this.externalSchemaLocation;
    }

    public void setExternalSchemaLocation(String externalSchemaLocation) {
        this.externalSchemaLocation = externalSchemaLocation;
    }

    protected void initialise(MuleMessage message) {
        Document dom4jDoc;
        if (this.logger.isDebugEnabled()) {
            if (this.splitExpression.length() == 0) {
                this.logger.warn((Object)"splitExpression is not specified, no processing will take place");
            } else {
                this.logger.debug((Object)("splitExpression is " + this.splitExpression));
            }
        }
        Object src = message.getPayload();
        try {
            dom4jDoc = this.validateSchema ? XMLUtils.toDocument(src, this.getExternalSchemaLocation()) : XMLUtils.toDocument(src);
            if (dom4jDoc == null) {
                this.logger.error((Object)("Non-XML message payload: " + src.getClass().toString()));
                return;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to initialise the payload: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (this.splitExpression.length() > 0) {
            XPath xpath = dom4jDoc.createXPath(this.splitExpression);
            if (this.namespaces != null) {
                xpath.setNamespaceURIs(this.namespaces);
            }
            List foundNodes = xpath.selectNodes((Object)dom4jDoc);
            if (this.enableCorrelation != 2) {
                message.setCorrelationGroupSize(foundNodes.size());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Split into " + foundNodes.size()));
            }
            LinkedList<Document> parts = new LinkedList<Document>();
            for (Node node : foundNodes) {
                if (node instanceof Element) {
                    node = (Node)node.clone();
                    parts.add(DocumentHelper.createDocument((Element)((Element)node)));
                    continue;
                }
                this.logger.warn((Object)("Dcoument node: " + node.asXML() + " is not an element and thus is not a valid part"));
            }
            this.nodesContext.set(parts);
        }
        HashMap<String, Object> theProperties = new HashMap<String, Object>();
        for (String propertyKey : message.getPropertyNames()) {
            theProperties.put(propertyKey, message.getProperty(propertyKey));
        }
        this.propertiesContext.set(theProperties);
    }

    protected void cleanup() {
        this.nodesContext.set(null);
        this.propertiesContext.set(null);
    }

    protected MuleMessage getMessagePart(MuleMessage message, OutboundEndpoint endpoint) {
        List nodes = (List)this.nodesContext.get();
        if (nodes == null) {
            this.logger.error((Object)"Error: nodes are null");
            return null;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Document doc = (Document)i.next();
            try {
                Map theProperties = (Map)this.propertiesContext.get();
                DefaultMuleMessage result = new DefaultMuleMessage((Object)doc, new HashMap(theProperties));
                if (endpoint.getFilter() == null || endpoint.getFilter().accept((MuleMessage)result)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Endpoint filter matched for node " + i + " of " + nodes.size() + ". Routing message over: " + endpoint.getEndpointURI().toString()));
                    }
                    i.remove();
                    return result;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)"Endpoint filter did not match, returning null");
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create message for node at position " + i), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

