/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.RequestContext;
import org.mule.transformers.xml.AbstractXmlTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class XsltTransformer
extends AbstractXmlTransformer {
    private static final int MIN_IDLE_TRANSFORMERS = 1;
    private static final int MAX_IDLE_TRANSFORMERS = 32;
    private static final int MAX_ACTIVE_TRANSFORMERS = 32;
    private static final String PARAM_EVAL_TOKEN = "#";
    protected final GenericObjectPool transformerPool = new GenericObjectPool((PoolableObjectFactory)new PooledXsltTransformerFactory());
    private volatile String xslTransformerFactoryClassName;
    private volatile String xslFile;
    private volatile String xslt;
    private volatile Map transformParameters;
    private URIResolver uriResolver;

    public XsltTransformer() {
        this.transformerPool.setMinIdle(1);
        this.transformerPool.setMaxIdle(32);
        this.transformerPool.setMaxActive(32);
        this.uriResolver = new LocalURIResolver();
    }

    public void initialise() throws InitialisationException {
        try {
            this.transformerPool.addObject();
        }
        catch (Throwable te) {
            throw new InitialisationException(te, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Object result;
            block10: {
                Source sourceDoc = this.getXmlSource(src);
                if (sourceDoc == null) {
                    return null;
                }
                AbstractXmlTransformer.ResultHolder holder = XsltTransformer.getResultHolder(this.returnClass);
                if (holder == null) {
                    holder = XsltTransformer.getResultHolder(src.getClass());
                }
                DefaultErrorListener errorListener = new DefaultErrorListener((UMOTransformer)this);
                Transformer transformer = null;
                try {
                    transformer = (Transformer)this.transformerPool.borrowObject();
                    transformer.setErrorListener(errorListener);
                    transformer.setOutputProperty("encoding", encoding);
                    if (this.transformParameters != null) {
                        Iterator i = this.transformParameters.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry parameter = i.next();
                            String key = (String)parameter.getKey();
                            transformer.setParameter(key, this.evaluateTransformParameter(key, parameter.getValue()));
                        }
                    }
                    transformer.transform(sourceDoc, holder.getResult());
                    result = holder.getResultObject();
                    if (errorListener.isError()) {
                        throw errorListener.getException();
                    }
                    Object var12_12 = null;
                    if (transformer == null) break block10;
                    transformer.clearParameters();
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (transformer != null) {
                        transformer.clearParameters();
                        this.transformerPool.returnObject((Object)transformer);
                    }
                    throw throwable;
                }
                this.transformerPool.returnObject((Object)transformer);
                {
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    public String getXslTransformerFactory() {
        return this.xslTransformerFactoryClassName;
    }

    public void setXslTransformerFactory(String xslTransformerFactory) {
        this.xslTransformerFactoryClassName = xslTransformerFactory;
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    protected StreamSource getStreamSource() throws InitialisationException {
        InputStream is;
        if (this.xslt != null) {
            return new StreamSource(new StringReader(this.xslt));
        }
        if (this.xslFile == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"xslFile"), (Object)this);
        }
        try {
            is = IOUtils.getResourceAsStream((String)this.xslFile, ((Object)((Object)this)).getClass());
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        if (is != null) {
            return new StreamSource(is);
        }
        throw new InitialisationException(CoreMessages.failedToLoad((String)this.xslFile), (Object)this);
    }

    public Object clone() throws CloneNotSupportedException {
        XsltTransformer clone = (XsltTransformer)((Object)super.clone());
        try {
            if (clone.nextTransformer == null) {
                clone.initialise();
            }
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return clone;
    }

    public int getMaxActiveTransformers() {
        return this.transformerPool.getMaxActive();
    }

    public void setMaxActiveTransformers(int maxActiveTransformers) {
        this.transformerPool.setMaxActive(maxActiveTransformers);
    }

    public int getMaxIdleTransformers() {
        return this.transformerPool.getMaxIdle();
    }

    public void setMaxIdleTransformers(int maxIdleTransformers) {
        this.transformerPool.setMaxIdle(maxIdleTransformers);
    }

    public Map getTransformParameters() {
        return this.transformParameters;
    }

    public void setTransformParameters(Map transformParameters) {
        this.transformParameters = transformParameters;
    }

    protected Object evaluateTransformParameter(String name, Object value) throws TransformerException {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (!stringValue.startsWith(PARAM_EVAL_TOKEN)) {
                return stringValue;
            }
            if (stringValue.startsWith("##")) {
                return stringValue.substring(1);
            }
            UMOEventContext context = RequestContext.getEventContext();
            if (context == null) {
                throw new TransformerException(CoreMessages.noCurrentEventForTransformer(), (UMOTransformer)this);
            }
            JXPathContext jxpathContext = JXPathContext.newContext((Object)context);
            return jxpathContext.getValue(stringValue.substring(1));
        }
        return value;
    }

    private class LocalURIResolver
    implements URIResolver {
        private LocalURIResolver() {
        }

        public Source resolve(String href, String base) throws javax.xml.transform.TransformerException {
            try {
                return new StreamSource(IOUtils.getResourceAsStream((String)href, this.getClass()));
            }
            catch (IOException e) {
                throw new javax.xml.transform.TransformerException(e);
            }
        }
    }

    protected class DefaultErrorListener
    implements ErrorListener {
        private TransformerException e = null;
        private final UMOTransformer trans;

        public DefaultErrorListener(UMOTransformer trans) {
            this.trans = trans;
        }

        public TransformerException getException() {
            return this.e;
        }

        public boolean isError() {
            return this.e != null;
        }

        public void error(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void fatalError(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void warning(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.warn((Object)exception.getMessage());
        }
    }

    protected class PooledXsltTransformerFactory
    extends BasePoolableObjectFactory {
        protected PooledXsltTransformerFactory() {
        }

        public Object makeObject() throws Exception {
            StreamSource source = XsltTransformer.this.getStreamSource();
            String factoryClassName = XsltTransformer.this.getXslTransformerFactory();
            TransformerFactory factory = StringUtils.isNotEmpty((String)factoryClassName) ? (TransformerFactory)ClassUtils.instanciateClass((String)factoryClassName, (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass()) : TransformerFactory.newInstance();
            factory.setURIResolver(XsltTransformer.this.uriResolver);
            return factory.newTransformer(source);
        }
    }
}

