/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.builder.ProxyClientMessageProcessorBuilder;
import org.mule.module.ws.consumer.InputSoapHeadersInterceptor;
import org.mule.module.ws.consumer.NamespaceRestorerStaxInterceptor;
import org.mule.module.ws.consumer.NamespaceSaverStaxInterceptor;
import org.mule.module.ws.consumer.OutputSoapHeadersInterceptor;
import org.mule.module.ws.consumer.RequestBodyGenerator;
import org.mule.module.ws.consumer.SoapActionInterceptor;
import org.mule.module.ws.consumer.SoapFaultException;
import org.mule.module.ws.consumer.SoapVersion;
import org.mule.module.ws.consumer.WSConsumerConfig;
import org.mule.module.ws.consumer.WSDLUtils;
import org.mule.module.ws.security.SecurityStrategy;
import org.mule.module.ws.security.WSSecurity;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSConsumer
implements MessageProcessor,
Initialisable,
MuleContextAware {
    public static final String SOAP_HEADERS_PROPERTY_PREFIX = "soap.";
    private static final Logger logger = LoggerFactory.getLogger(WSConsumer.class);
    private MuleContext muleContext;
    private String operation;
    private WSConsumerConfig config;
    private MessageProcessor messageProcessor;
    private String soapAction;
    private String requestBody;
    private SoapVersion soapVersion;
    private boolean mtomEnabled;

    public void initialise() throws InitialisationException {
        this.initializeConfiguration();
        this.parseWsdl();
        try {
            this.messageProcessor = this.createMessageProcessor();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.messageProcessor.process(event);
    }

    private void initializeConfiguration() throws InitialisationException {
        if (this.config == null) {
            try {
                this.config = (WSConsumerConfig)this.muleContext.getRegistry().lookupObject(WSConsumerConfig.class);
                if (this.config == null) {
                    throw new InitialisationException(CoreMessages.createStaticMessage((String)"No configuration defined for the web service consumer. Add a consumer-config element."), (Initialisable)this);
                }
            }
            catch (RegistrationException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    private MessageProcessor createMessageProcessor() throws MuleException {
        DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder();
        chainBuilder.chain(new MessageProcessor[]{new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                try {
                    if (WSConsumer.this.requestBody != null) {
                        event.getMessage().setPayload((Object)WSConsumer.this.requestBody);
                    }
                    WSConsumer.this.copyAttachmentsRequest(event);
                    MuleEvent result = this.processNext(event);
                    WSConsumer.this.copyAttachmentsResponse(result);
                    return result;
                }
                catch (DispatchException e) {
                    if (e.getCause() instanceof SoapFault) {
                        SoapFault soapFault = (SoapFault)e.getCause();
                        event.getMessage().setPayload((Object)soapFault.getDetail());
                        throw new SoapFaultException(event, soapFault.getFaultCode(), soapFault.getSubCode(), soapFault.getMessage(), soapFault.getDetail());
                    }
                    throw e;
                }
            }
        }});
        chainBuilder.chain(new MessageProcessor[]{new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                Object operation = event.getMessage().removeProperty("operation", PropertyScope.INVOCATION);
                MuleEvent result = this.processNext(event);
                if (operation != null) {
                    result.getMessage().setInvocationProperty("operation", operation);
                }
                return result;
            }
        }});
        chainBuilder.chain(new MessageProcessor[]{this.createCxfOutboundMessageProcessor(this.config.getSecurity())});
        chainBuilder.chain(new MessageProcessor[]{new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                ArrayList outboundProperties = new ArrayList(event.getMessage().getOutboundPropertyNames());
                for (String outboundProperty : outboundProperties) {
                    if (!outboundProperty.startsWith(WSConsumer.SOAP_HEADERS_PROPERTY_PREFIX)) continue;
                    event.getMessage().removeProperty(outboundProperty, PropertyScope.OUTBOUND);
                }
                MuleEvent result = this.processNext(event);
                Object statusCode = result.getMessage().getInboundProperty("http.status", null);
                if (statusCode != null && !(statusCode instanceof String)) {
                    result.getMessage().setProperty("http.status", (Object)statusCode.toString(), PropertyScope.INBOUND);
                }
                return result;
            }
        }});
        chainBuilder.chain(new MessageProcessor[]{this.config.createOutboundMessageProcessor()});
        return chainBuilder.build();
    }

    private CxfOutboundMessageProcessor createCxfOutboundMessageProcessor(WSSecurity security) throws MuleException {
        ProxyClientMessageProcessorBuilder cxfBuilder = new ProxyClientMessageProcessorBuilder();
        HashMap<String, Object> configProperties = new HashMap<String, Object>();
        cxfBuilder.setMtomEnabled(this.mtomEnabled);
        cxfBuilder.setMuleContext(this.muleContext);
        cxfBuilder.setSoapVersion(this.soapVersion.getVersion());
        if (security != null && security.hasStrategies()) {
            for (SecurityStrategy strategy : security.getStrategies()) {
                strategy.apply(configProperties);
            }
            if (cxfBuilder.getOutInterceptors() == null) {
                cxfBuilder.setOutInterceptors(new ArrayList());
            }
            cxfBuilder.getOutInterceptors().add(new WSS4JOutInterceptor(configProperties));
        }
        CxfOutboundMessageProcessor cxfOutboundMessageProcessor = cxfBuilder.build();
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new CheckFaultInterceptor());
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new NamespaceSaverStaxInterceptor());
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new NamespaceRestorerStaxInterceptor());
        if (this.soapAction != null) {
            cxfOutboundMessageProcessor.getClient().getOutInterceptors().add(new SoapActionInterceptor(this.soapAction));
        }
        cxfOutboundMessageProcessor.getClient().getOutInterceptors().add(new InputSoapHeadersInterceptor(this.muleContext));
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new OutputSoapHeadersInterceptor(this.muleContext));
        return cxfOutboundMessageProcessor;
    }

    private void parseWsdl() throws InitialisationException {
        Definition wsdlDefinition = null;
        URL url = IOUtils.getResourceAsUrl((String)this.config.getWsdlLocation(), this.getClass());
        if (url == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Can't find wsdl at %s", (Object[])new Object[]{this.config.getWsdlLocation()}), (Initialisable)this);
        }
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlDefinition = wsdlReader.readWSDL(url.toString());
        }
        catch (WSDLException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        Service service = wsdlDefinition.getService(new QName(wsdlDefinition.getTargetNamespace(), this.config.getService()));
        if (service == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Service %s not found in WSDL", (Object[])new Object[]{this.config.getService()}), (Initialisable)this);
        }
        Port port = service.getPort(this.config.getPort());
        if (port == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Port %s not found in WSDL", (Object[])new Object[]{this.config.getPort()}), (Initialisable)this);
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Port %s has no binding", (Object[])new Object[]{this.config.getPort()}), (Initialisable)this);
        }
        BindingOperation bindingOperation = binding.getBindingOperation(this.operation, null, null);
        if (bindingOperation == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Operation %s not found in WSDL", (Object[])new Object[]{this.operation}), (Initialisable)this);
        }
        this.soapVersion = WSDLUtils.getSoapVersion(binding);
        this.soapAction = this.getSoapAction(bindingOperation);
        RequestBodyGenerator requestBodyGenerator = new RequestBodyGenerator(wsdlDefinition);
        this.requestBody = requestBodyGenerator.generateRequestBody(bindingOperation);
    }

    private String getSoapAction(BindingOperation bindingOperation) {
        List extensions = bindingOperation.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAPOperation) {
                return ((SOAPOperation)extension).getSoapActionURI();
            }
            if (!(extension instanceof SOAP12Operation)) continue;
            return ((SOAP12Operation)extension).getSoapActionURI();
        }
        return null;
    }

    private void copyAttachmentsRequest(MuleEvent event) {
        MuleMessage message = event.getMessage();
        if (!message.getOutboundAttachmentNames().isEmpty()) {
            HashSet<AttachmentImpl> attachments = new HashSet<AttachmentImpl>(message.getOutboundAttachmentNames().size());
            for (String outboundAttachmentName : message.getOutboundAttachmentNames()) {
                AttachmentImpl attachment = new AttachmentImpl(outboundAttachmentName, message.getOutboundAttachment(outboundAttachmentName));
                attachments.add(attachment);
            }
            message.setInvocationProperty("cxf_attachments", attachments);
            message.clearAttachments();
        }
    }

    private void copyAttachmentsResponse(MuleEvent event) throws MessagingException {
        MuleMessage message = event.getMessage();
        if (message.getInvocationProperty("cxf_attachments") != null) {
            Collection attachments = (Collection)message.getInvocationProperty("cxf_attachments");
            for (Attachment attachment : attachments) {
                try {
                    ((DefaultMuleMessage)message).addInboundAttachment(attachment.getId(), attachment.getDataHandler());
                }
                catch (Exception e) {
                    throw new MessagingException(CoreMessages.createStaticMessage((String)"Could not set inbound attachment %s", (Object[])new Object[]{attachment.getId()}), event, (Throwable)e);
                }
            }
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public WSConsumerConfig getConfig() {
        return this.config;
    }

    public void setConfig(WSConsumerConfig config) {
        this.config = config;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }
}

