/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.ArrayList;
import java.util.List;
import org.mule.extension.validation.api.MultipleValidationException;
import org.mule.extension.validation.api.MultipleValidationResult;
import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableMultipleValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.extension.api.annotation.RestrictedTo;

public final class ValidationStrategies {
    public void all(@RestrictedTo(value=ValidationExtension.class) List<NestedProcessor> validations, Event muleEvent) throws MultipleValidationException {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(validations.size());
        for (NestedProcessor validation : validations) {
            try {
                validation.process();
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause == null) {
                    rootCause = e;
                }
                results.add(ImmutableValidationResult.error(rootCause.getMessage()));
            }
        }
        MultipleValidationResult result = ImmutableMultipleValidationResult.of(results);
        if (result.isError()) {
            throw new MultipleValidationException(result);
        }
    }
}

