/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.extension.validation.api.ObjectSource;
import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationOptions;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ValidationSupport;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;

public final class CustomValidatorOperation
extends ValidationSupport {
    private final LoadingCache<ValidatorSource, Validator> class2ValidatorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ValidatorSource, Validator>(){

        public Validator load(ValidatorSource validatorSource) throws Exception {
            return validatorSource.createValidator();
        }
    });

    public void customValidator(@ParameterGroup(value="Validator") ObjectSource<Validator> source, @ParameterGroup(value="Error options") ValidationOptions options, Event event, @UseConfig ValidationExtension config) throws Exception {
        ValidatorSource validatorSource = new ValidatorSource(source.getType(), source.getRef());
        Validator validator = (Validator)validatorSource.getObject(this.muleContext);
        this.validateWith(validator, this.createContext(options, event, config), event);
    }

    @Override
    protected void logSuccessfulValidation(Validator validator, Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully executed custom validator of type {} on message: {}", (Object)validator.getClass().getName(), (Object)event.getMessage());
        }
    }

    private class ValidatorSource
    extends ObjectSource<Validator> {
        public ValidatorSource(String type, String ref) {
            super(type, ref);
        }

        @Override
        protected Validator doGetByClassName() {
            return (Validator)CustomValidatorOperation.this.class2ValidatorCache.getUnchecked((Object)this);
        }

        private Validator createValidator() {
            return (Validator)super.doGetByClassName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValidatorSource) {
                return this.getType().equals(((ValidatorSource)obj).getType());
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode();
        }
    }
}

