/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.api;

import java.util.Locale;
import org.mule.extension.validation.api.ExceptionFactory;
import org.mule.extension.validation.api.ExceptionFactorySource;
import org.mule.extension.validation.api.I18NConfig;
import org.mule.extension.validation.internal.CommonValidationOperations;
import org.mule.extension.validation.internal.CustomValidatorOperation;
import org.mule.extension.validation.internal.DefaultExceptionFactory;
import org.mule.extension.validation.internal.NumberValidationOperation;
import org.mule.extension.validation.internal.ValidationMessages;
import org.mule.extension.validation.internal.ValidationStrategies;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.util.ObjectNameHelper;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Extension(name="Validation Module", description="Allows performing validations and throw an Exception if the validation fails")
@Operations(value={CommonValidationOperations.class, CustomValidatorOperation.class, ValidationStrategies.class, NumberValidationOperation.class})
@Extensible(alias="validator-message-processor")
@Export(resources={"/META-INF/services/org/mule/runtime/core/i18n/validation-messages.properties"})
public class ValidationExtension
extends AbstractAnnotatedObject
implements Config,
NamedObject,
Initialisable,
MuleContextAware {
    public static final String DEFAULT_LOCALE = Locale.getDefault().getLanguage();
    private static final String EXCEPTION_FACTORY_PARAMETER_NAME = "exceptionFactory";
    private ValidationMessages messageFactory;
    private ExceptionFactory exceptionFactory;
    private MuleContext muleContext;
    @Parameter
    @Alias(value="exceptionFactory")
    @Optional
    private ExceptionFactorySource exceptionFactorySource;
    @Parameter
    @Optional
    private I18NConfig i18n;

    public void initialise() throws InitialisationException {
        this.initialiseExceptionFactory();
        this.initialiseMessageFactory();
    }

    private void initialiseMessageFactory() {
        this.messageFactory = this.i18n == null ? new ValidationMessages() : new ValidationMessages(this.i18n.getBundlePath(), this.i18n.getLocale());
    }

    private void initialiseExceptionFactory() throws InitialisationException {
        if (this.exceptionFactorySource == null) {
            this.exceptionFactory = new DefaultExceptionFactory();
        } else {
            try {
                this.exceptionFactory = (ExceptionFactory)this.exceptionFactorySource.getObject(this.muleContext);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        try {
            ObjectNameHelper objectNameHelper = new ObjectNameHelper(this.muleContext);
            this.muleContext.getRegistry().registerObject(objectNameHelper.getUniqueName(EXCEPTION_FACTORY_PARAMETER_NAME), (Object)this.exceptionFactory);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not register ExceptionFactory of class " + this.exceptionFactory.getClass().getName())), (Throwable)e);
        }
    }

    public ValidationMessages getMessageFactory() {
        return this.messageFactory;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public String getName() {
        return "Validation";
    }
}

