/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.Locale;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.mule.api.MuleEvent;
import org.mule.extension.validation.api.ValidationException;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ValidationExtension;
import org.mule.extension.validation.internal.ValidationOptions;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ValidationSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    ValidationSupport() {
    }

    protected void validateWith(Validator validator, ValidationContext validationContext, MuleEvent event) throws Exception {
        ValidationResult result = validator.validate(event);
        if (result.isError()) {
            result = this.evaluateCustomMessage(result, validationContext);
            String customExceptionClass = validationContext.getOptions().getExceptionClass();
            if (StringUtils.isEmpty((String)customExceptionClass)) {
                throw validationContext.getConfig().getExceptionFactory().createException(result, ValidationException.class, event);
            }
            throw validationContext.getConfig().getExceptionFactory().createException(result, customExceptionClass, event);
        }
        this.logSuccessfulValidation(validator, event);
    }

    private ValidationResult evaluateCustomMessage(ValidationResult result, ValidationContext validationContext) {
        String customMessage = validationContext.getOptions().getMessage();
        if (!StringUtils.isBlank((String)customMessage)) {
            result = ImmutableValidationResult.error(validationContext.getMuleEvent().getMuleContext().getExpressionManager().parse(customMessage, validationContext.getMuleEvent()));
        }
        return result;
    }

    protected ValidationContext createContext(ValidationOptions options, MuleEvent muleEvent, ValidationExtension config) {
        return new ValidationContext(options, muleEvent, config);
    }

    protected Locale parseLocale(String locale) {
        locale = StringUtils.isBlank((String)locale) ? ValidationExtension.DEFAULT_LOCALE : locale;
        return new Locale(locale);
    }

    protected void logSuccessfulValidation(Validator validator, MuleEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully executed validator {}", (Object)ToStringBuilder.reflectionToString((Object)validator));
        }
    }
}

