/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.el;

import java.util.Locale;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ValidationExtension;
import org.mule.extension.validation.internal.ValidationMessages;
import org.mule.extension.validation.internal.ValidationOptions;
import org.mule.extension.validation.internal.validator.EmailValidator;
import org.mule.extension.validation.internal.validator.EmptyValidator;
import org.mule.extension.validation.internal.validator.IpValidator;
import org.mule.extension.validation.internal.validator.MatchesRegexValidator;
import org.mule.extension.validation.internal.validator.NotEmptyValidator;
import org.mule.extension.validation.internal.validator.NotNullValidator;
import org.mule.extension.validation.internal.validator.NullValidator;
import org.mule.extension.validation.internal.validator.NumberType;
import org.mule.extension.validation.internal.validator.NumberValidator;
import org.mule.extension.validation.internal.validator.SizeValidator;
import org.mule.extension.validation.internal.validator.TimeValidator;
import org.mule.extension.validation.internal.validator.UrlValidator;

public final class ValidatorElContext {
    private final MuleEvent event;
    private final ValidationContext validationContext;

    public ValidatorElContext(MuleEvent event) {
        this.event = event;
        this.validationContext = new ValidationContext(new ValidationMessages(), new ValidationOptions(), event);
    }

    public ValidatorElContext() {
        this.event = VoidMuleEvent.getInstance();
        this.validationContext = new ValidationContext(new ValidationMessages(), new ValidationOptions(), this.event);
    }

    public boolean validateEmail(String email) {
        return this.validate(new EmailValidator(email, this.validationContext));
    }

    public boolean matchesRegex(String value, String regex, boolean caseSensitive) {
        return this.validate(new MatchesRegexValidator(value, regex, caseSensitive, this.validationContext));
    }

    public boolean isTime(String time, String pattern) {
        return this.isTime(time, pattern, ValidationExtension.DEFAULT_LOCALE);
    }

    public boolean isTime(String time, String pattern, String locale) {
        return this.validate(new TimeValidator(time, locale, pattern, this.validationContext));
    }

    public boolean isEmpty(Object value) {
        return this.validate(new EmptyValidator(value, this.validationContext));
    }

    public boolean notEmpty(Object value) {
        return this.validate(new NotEmptyValidator(value, this.validationContext));
    }

    public boolean validateSize(Object value, int min, int max) {
        return this.validate(new SizeValidator(value, min, max, this.validationContext));
    }

    public boolean isNotNull(Object value) {
        return this.validate(new NotNullValidator(value, this.validationContext));
    }

    public boolean isNull(Object value) {
        return this.validate(new NullValidator(value, this.validationContext));
    }

    public boolean isNumber(String value, NumberType numberType) {
        return this.isNumber(value, numberType, null, null);
    }

    public boolean isNumber(String value, NumberType numberType, Number minValue, Number maxValue) {
        return this.isNumber(value, numberType, minValue, maxValue, null, ValidationExtension.DEFAULT_LOCALE);
    }

    public boolean isNumber(String value, NumberType numberType, Number minValue, Number maxValue, String pattern, String locale) {
        return this.validate(new NumberValidator(value, new Locale(locale), pattern, minValue, maxValue, numberType, this.validationContext));
    }

    public boolean validateIp(String ip) {
        return this.validate(new IpValidator(ip, this.validationContext));
    }

    public boolean validateUrl(String url) {
        return this.validate(new UrlValidator(url, this.validationContext));
    }

    private boolean validate(Validator validator) {
        return !validator.validate(this.event).isError();
    }
}

