/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.spring.transaction;

import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionException;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.transaction.AbstractSingleResourceTransaction;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionFactory
implements TransactionFactory {
    private PlatformTransactionManager manager;

    public Transaction beginTransaction(MuleContext muleContext) throws TransactionException {
        SpringTransaction tx = new SpringTransaction(muleContext);
        tx.begin();
        return tx;
    }

    public boolean isTransacted() {
        return true;
    }

    public synchronized PlatformTransactionManager getManager() {
        return this.manager;
    }

    public synchronized void setManager(PlatformTransactionManager manager) {
        this.manager = manager;
    }

    public class SpringTransaction
    extends AbstractSingleResourceTransaction {
        protected final TransactionStatus status;

        public SpringTransaction(MuleContext muleContext) {
            super(muleContext);
            this.status = SpringTransactionFactory.this.manager.getTransaction(null);
        }

        protected void doBegin() throws TransactionException {
        }

        protected void doCommit() throws TransactionException {
            SpringTransactionFactory.this.manager.commit(this.status);
        }

        protected void doRollback() throws TransactionException {
            SpringTransactionFactory.this.manager.rollback(this.status);
        }

        public Object getResource(Object key) {
            Object res = TransactionSynchronizationManager.getResource((Object)key);
            if (res != null) {
                if (!(res instanceof ConnectionHolder)) {
                    if (res instanceof JmsResourceHolder) {
                        return ((JmsResourceHolder)res).getConnection();
                    }
                } else {
                    return ((ConnectionHolder)res).getConnection();
                }
            }
            return res;
        }

        public boolean hasResource(Object key) {
            return this.getResource(key) != null;
        }

        public void bindResource(Object key, Object resource) throws TransactionException {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() {
            super.setRollbackOnly();
            this.status.setRollbackOnly();
        }
    }
}

