/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.spring.remoting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.springframework.remoting.support.RemoteInvocation;

public class ObjectToRemoteInvocationTransformer
extends AbstractTransformer {
    public ObjectToRemoteInvocationTransformer() {
        this.registerSourceType(DataType.fromType(RemoteInvocation.class));
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.setReturnDataType(DataType.fromType(RemoteInvocation.class));
    }

    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        Object o;
        block32: {
            if (src instanceof RemoteInvocation) {
                return src;
            }
            o = null;
            if (src instanceof InputStream) {
                try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), (InputStream)src);){
                    o = ois.readObject();
                    break block32;
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            byte[] data = (byte[])src;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), (InputStream)bais);){
                o = ois.readObject();
            }
            catch (Exception e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
        RemoteInvocation ri = (RemoteInvocation)o;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("request to execute " + ri.getMethodName());
            for (int i = 0; i < ri.getArguments().length; ++i) {
                Object currentArgument = ri.getArguments()[i];
                StringBuilder buf = new StringBuilder(64);
                buf.append("with argument (");
                buf.append(currentArgument == null ? "<null>" : currentArgument.toString());
                buf.append(")");
                this.logger.debug(buf.toString());
            }
        }
        return ri;
    }
}

