/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.events;

import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.ObjectFilter;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.TransformerException;
import org.mule.component.DefaultJavaComponent;
import org.mule.config.QueueProfile;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.module.spring.events.ApplicationEventException;
import org.mule.module.spring.events.AsynchronousEventListener;
import org.mule.module.spring.events.MuleApplicationEvent;
import org.mule.module.spring.events.MuleEventListener;
import org.mule.module.spring.events.MuleSubscriptionEventListener;
import org.mule.module.spring.i18n.SpringMessages;
import org.mule.object.SingletonObjectFactory;
import org.mule.routing.filters.WildcardFilter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.util.ClassUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.ResolvableType;

@Deprecated
public class MuleEventMulticaster
implements ApplicationEventMulticaster,
ApplicationContextAware,
MuleContextAware,
Callable,
Initialisable {
    public static final String EVENT_MULTICASTER_DESCRIPTOR_NAME = "muleEventMulticasterDescriptor";
    protected static final Log logger = LogFactory.getLog(MuleEventMulticaster.class);
    protected final Set listeners = new CopyOnWriteArraySet();
    protected boolean asynchronous = false;
    protected ExecutorService asyncPool = null;
    protected String[] subscriptions = null;
    protected ApplicationContext applicationContext;
    protected Service service;
    protected Class<? extends Filter> subscriptionFilter = WildcardFilter.class;
    protected ExceptionListener exceptionListener = new LoggingExceptionListener();
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        if (this.asynchronous) {
            if (this.asyncPool == null) {
                this.asyncPool = this.muleContext.getDefaultThreadingProfile().createPool("spring-events");
            }
        } else if (this.asyncPool != null) {
            this.asyncPool.shutdown();
            this.asyncPool = null;
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        ApplicationListener listenerToAdd = listener;
        if (this.asynchronous) {
            listenerToAdd = new AsynchronousEventListener(this.asyncPool, listener);
        }
        this.listeners.add(listenerToAdd);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        for (ApplicationListener applicationListener : this.listeners) {
            if (applicationListener instanceof AsynchronousEventListener) {
                if (!((AsynchronousEventListener)applicationListener).getListener().equals(listener)) continue;
                this.listeners.remove(applicationListener);
                return;
            }
            if (!applicationListener.equals(listener)) continue;
            this.listeners.remove(applicationListener);
            return;
        }
        this.listeners.remove(listener);
    }

    public void addApplicationListenerBean(String s) {
        Object listener = this.applicationContext.getBean(s);
        if (!(listener instanceof ApplicationListener)) {
            throw new IllegalArgumentException(SpringMessages.beanNotInstanceOfApplicationListener(s).getMessage());
        }
        this.addApplicationListener((ApplicationListener)listener);
    }

    public void removeApplicationListenerBean(String s) {
        Object listener = this.applicationContext.getBean(s);
        if (!(listener instanceof ApplicationListener)) {
            throw new IllegalArgumentException(SpringMessages.beanNotInstanceOfApplicationListener(s).getMessage());
        }
        this.removeApplicationListener((ApplicationListener)listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void multicastEvent(ApplicationEvent e) {
        MuleApplicationEvent muleEvent = null;
        if (e instanceof ContextRefreshedEvent) {
            try {
                this.registerMulticasterComponent();
            }
            catch (MuleException ex) {
                throw new MuleRuntimeException(SpringMessages.failedToReinitMule(), (Throwable)ex);
            }
        }
        if (e instanceof ContextClosedEvent) {
            if (!this.muleContext.isDisposing() && !this.muleContext.isDisposed()) {
                this.muleContext.dispose();
            }
            return;
        }
        if (e instanceof MuleApplicationEvent && (muleEvent = (MuleApplicationEvent)e).getMuleEventContext() == null) {
            try {
                this.dispatchEvent(muleEvent);
            }
            catch (ApplicationEventException e1) {
                this.exceptionListener.exceptionThrown(e1);
            }
            return;
        }
        block4: for (ApplicationListener listener : this.listeners) {
            if (muleEvent != null) {
                if (listener instanceof AsynchronousEventListener) {
                    AsynchronousEventListener asyncListener = (AsynchronousEventListener)listener;
                    if (asyncListener.getListener() instanceof MuleSubscriptionEventListener) {
                        if (!this.isSubscriptionMatch(muleEvent.getEndpoint(), ((MuleSubscriptionEventListener)asyncListener.getListener()).getSubscriptions())) continue;
                        asyncListener.onApplicationEvent(muleEvent);
                        continue;
                    }
                    if (asyncListener.getListener() instanceof MuleEventListener) {
                        asyncListener.onApplicationEvent(muleEvent);
                        continue;
                    }
                    if (asyncListener.getListener() instanceof MuleEventListener) continue;
                    asyncListener.onApplicationEvent(e);
                    continue;
                }
                if (listener instanceof MuleSubscriptionEventListener) {
                    if (!this.isSubscriptionMatch(muleEvent.getEndpoint(), ((MuleSubscriptionEventListener)listener).getSubscriptions())) continue;
                    listener.onApplicationEvent((ApplicationEvent)muleEvent);
                    continue;
                }
                if (!(listener instanceof MuleEventListener)) continue;
                listener.onApplicationEvent((ApplicationEvent)muleEvent);
                continue;
            }
            if (listener instanceof AsynchronousEventListener && !(((AsynchronousEventListener)listener).getListener() instanceof MuleEventListener)) {
                listener.onApplicationEvent(e);
                continue;
            }
            if (!(listener instanceof MuleEventListener)) {
                listener.onApplicationEvent(e);
                continue;
            }
            for (int i = 0; i < listener.getClass().getInterfaces().length; ++i) {
                if (!listener.getClass().getInterfaces()[i].equals(ApplicationListener.class)) continue;
                listener.onApplicationEvent(e);
                continue block4;
            }
        }
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        this.multicastEvent(event);
    }

    private boolean isSubscriptionMatch(String endpoint, String[] subscriptions) {
        for (int i = 0; i < subscriptions.length; ++i) {
            String subscription = subscriptions[i];
            ObjectFilter filter = this.createFilter(subscription);
            if (!filter.accept((Object)endpoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public Object onCall(MuleEventContext context) throws TransformerException, MalformedEndpointException {
        this.multicastEvent(new MuleApplicationEvent(context.getMessage().getPayload(), context, this.applicationContext));
        context.setStopFurtherProcessing(true);
        return null;
    }

    protected void dispatchEvent(MuleApplicationEvent applicationEvent) throws ApplicationEventException {
        OutboundEndpoint endpoint;
        try {
            endpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint(applicationEvent.getEndpoint());
        }
        catch (MuleException e) {
            throw new ApplicationEventException("Failed to get endpoint for endpointUri: " + applicationEvent.getEndpoint(), e);
        }
        if (endpoint != null) {
            try {
                DefaultMuleMessage message = new DefaultMuleMessage(applicationEvent.getSource(), applicationEvent.getProperties(), this.muleContext);
                if (applicationEvent.getMuleEventContext() != null) {
                    applicationEvent.getMuleEventContext().setStopFurtherProcessing(true);
                    applicationEvent.getMuleEventContext().dispatchEvent((MuleMessage)message, endpoint);
                }
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, endpoint.getExchangePattern(), (FlowConstruct)this.service);
                RequestContext.setEvent((MuleEvent)event);
                if (endpoint.getTransformers() != null) {
                    message = new DefaultMuleMessage(applicationEvent.getSource(), applicationEvent.getProperties(), this.muleContext);
                    message.applyTransformers((MuleEvent)event, endpoint.getTransformers());
                }
                endpoint.process((MuleEvent)new DefaultMuleEvent((MuleMessage)message, endpoint.getExchangePattern(), (FlowConstruct)this.service));
            }
            catch (Exception e1) {
                throw new ApplicationEventException("Failed to dispatch event: " + e1.getMessage(), e1);
            }
        } else {
            throw new ApplicationEventException("Failed endpoint using name: " + applicationEvent.getEndpoint());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void registerMulticasterComponent() throws MuleException {
        if (this.service == null) {
            this.service = this.getDefaultService();
            this.setSubscriptionsOnService(this.service);
            this.muleContext.getRegistry().registerService(this.service);
        }
    }

    protected void setSubscriptionsOnService(Service service) throws MuleException {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (ApplicationListener listener : this.listeners) {
            if (listener instanceof AsynchronousEventListener) {
                listener = ((AsynchronousEventListener)listener).getListener();
            }
            if (!(listener instanceof MuleSubscriptionEventListener)) continue;
            String[] subscriptions = ((MuleSubscriptionEventListener)listener).getSubscriptions();
            for (int i = 0; i < subscriptions.length; ++i) {
                boolean isSoap;
                if (subscriptions[i].indexOf("*") != -1 || !MuleEndpointURI.isMuleUri((String)subscriptions[i]) || (isSoap = this.registerAsSoap(subscriptions[i], listener))) continue;
                endpoints.add(subscriptions[i]);
            }
        }
        if (endpoints.size() > 0) {
            for (String endpoint : endpoints) {
                InboundEndpoint ep = this.muleContext.getEndpointFactory().getInboundEndpoint(endpoint);
                if (((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint(ep.getName()) != null) continue;
                ((ServiceCompositeMessageSource)service.getMessageSource()).addSource((MessageSource)ep);
            }
        }
    }

    private boolean registerAsSoap(String endpoint, Object listener) throws MuleException {
        if (endpoint.startsWith("soap") || endpoint.startsWith("axis") || endpoint.startsWith("cxf")) {
            int i;
            MuleEndpointURI ep = new MuleEndpointURI(endpoint, this.muleContext);
            String serviceName = null;
            if (ep.getPath() != null) {
                String path = ep.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((i = path.lastIndexOf("/")) > -1) {
                    serviceName = path.substring(i + 1);
                }
            } else {
                serviceName = this.service.getName();
            }
            String newEndpoint = endpoint;
            i = newEndpoint.indexOf(serviceName);
            newEndpoint = newEndpoint.substring(0, i - 1);
            SedaService s = new SedaService(this.muleContext);
            s.setName(serviceName);
            s.setModel(this.muleContext.getRegistry().lookupSystemModel());
            QueueProfile queueProfile = QueueProfile.newInstancePersistingToDefaultMemoryQueueStore((MuleContext)this.muleContext);
            s.setQueueProfile(queueProfile);
            ((CompositeMessageSource)s.getMessageSource()).addSource((MessageSource)this.muleContext.getEndpointFactory().getInboundEndpoint(newEndpoint));
            DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)new SingletonObjectFactory(listener));
            component.setMuleContext(this.muleContext);
            s.setComponent((Component)component);
            this.muleContext.getRegistry().registerService((Service)s);
            return true;
        }
        return false;
    }

    protected Service getDefaultService() throws MuleException {
        Service service;
        Model model = this.muleContext.getRegistry().lookupModel("_muleSystemModel");
        if (model == null) {
            model = new SedaModel();
            model.setName("_muleSystemModel");
            this.muleContext.getRegistry().registerModel(model);
        }
        if ((service = this.muleContext.getRegistry().lookupService(EVENT_MULTICASTER_DESCRIPTOR_NAME)) != null) {
            this.muleContext.getRegistry().unregisterService(service.getName());
        }
        service = new SedaService(this.muleContext);
        service.setName(EVENT_MULTICASTER_DESCRIPTOR_NAME);
        service.setModel(model);
        if (this.subscriptions == null) {
            logger.info((Object)"No receive endpoints have been set, using default '*'");
            ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)this.muleContext.getEndpointFactory().getInboundEndpoint("vm://*"));
        } else {
            ServiceCompositeMessageSource messageRouter = (ServiceCompositeMessageSource)service.getMessageSource();
            for (int i = 0; i < this.subscriptions.length; ++i) {
                String subscription = this.subscriptions[i];
                EndpointFactory endpointFactory = this.muleContext.getEndpointFactory();
                EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(subscription);
                endpointBuilder.setExchangePattern(MessageExchangePattern.fromSyncFlag((!this.asynchronous ? 1 : 0) != 0));
                InboundEndpoint endpoint = endpointFactory.getInboundEndpoint(endpointBuilder);
                messageRouter.addSource((MessageSource)endpoint);
            }
        }
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)new SingletonObjectFactory((Object)this));
        component.setMuleContext(this.muleContext);
        service.setComponent((Component)component);
        return service;
    }

    protected ObjectFilter createFilter(String pattern) {
        try {
            if (this.getSubscriptionFilter() == null) {
                this.setSubscriptionFilter(WildcardFilter.class);
            }
            return (ObjectFilter)ClassUtils.instanciateClass(this.getSubscriptionFilter(), (Object[])new Object[]{pattern});
        }
        catch (Exception e) {
            this.exceptionListener.exceptionThrown(e);
            return new WildcardFilter(pattern);
        }
    }

    public Class<? extends Filter> getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public void setSubscriptionFilter(Class<? extends Filter> subscriptionFilter) {
        this.subscriptionFilter = subscriptionFilter;
    }

    public String[] getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(String[] subscriptions) {
        this.subscriptions = subscriptions;
    }

    protected void setExceptionListener(ExceptionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("exceptionListener may not be null");
        }
        this.exceptionListener = listener;
    }

    private static class LoggingExceptionListener
    implements ExceptionListener {
        @Override
        public void exceptionThrown(Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

